/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo.builders;

import com.mongodb.client.model.Collation;
import dev.pumpo5.remote.mongo.MongoApplicationSupport;
import dev.pumpo5.remote.mongo.QueryResponse;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

public class QueryBuilder {
    private final MongoApplicationSupport application;
    private final String collection;
    private final Map<String, String> options;
    private Document filter;
    private Document sort;
    private Document projection;
    private Document hint;

    public QueryBuilder(MongoApplicationSupport application, String collection) {
        this.application = application;
        this.collection = collection;
        this.filter = new Document();
        this.options = new HashMap<String, String>();
        this.sort = new Document();
        this.projection = new Document();
        this.hint = new Document();
    }

    public QueryBuilder filter(Document filter) {
        this.filter.putAll((Map)filter);
        return this;
    }

    public QueryBuilder filter(String key, Object value) {
        this.filter.put(key, value);
        return this;
    }

    public QueryBuilder project(Document projection) {
        this.projection.putAll((Map)projection);
        return this;
    }

    public QueryBuilder project(String key, Object value) {
        this.projection.put(key, value);
        return this;
    }

    public QueryBuilder sort(Document sort) {
        this.sort.putAll((Map)sort);
        return this;
    }

    public QueryBuilder sort(String key, Object value) {
        this.sort.put(key, value);
        return this;
    }

    public QueryBuilder limit(long limit) {
        this.options.put("limit", String.valueOf(limit));
        return this;
    }

    public QueryBuilder skip(long skip) {
        this.options.put("skip", String.valueOf(skip));
        return this;
    }

    public QueryBuilder collation(Collation collation) {
        this.options.put("collation", collation.asDocument().toJson());
        return this;
    }

    public QueryBuilder allowDiskUse(boolean allow) {
        this.options.put("allowDiskUse", String.valueOf(allow));
        return this;
    }

    public QueryBuilder batchSize(int batchSize) {
        this.options.put("batchSize", String.valueOf(batchSize));
        return this;
    }

    public QueryBuilder comment(String comment) {
        this.options.put("comment", comment);
        return this;
    }

    public QueryBuilder hint(Document hint) {
        this.hint.putAll((Map)hint);
        return this;
    }

    public QueryBuilder hint(String key, Object value) {
        this.hint.put(key, value);
        return this;
    }

    public QueryBuilder hintString(String hintString) {
        this.options.put("hintString", hintString);
        return this;
    }

    public QueryBuilder maxTime(long maxTime) {
        this.options.put("maxTime", String.valueOf(maxTime));
        return this;
    }

    public QueryResponse execute() {
        this.options.put("sort", this.sort.toJson());
        this.options.put("projection", this.projection.toJson());
        this.options.put("hint", this.hint.toJson());
        return this.application.query(this.filter.toJson(), this.options, this.collection);
    }
}

