/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo.builders;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.UpdateOptions;
import dev.pumpo5.remote.mongo.MongoApplicationSupport;
import dev.pumpo5.remote.mongo.UpdateResponse;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

public class UpdateBuilder {
    protected final MongoApplicationSupport application;
    private final String collection;
    private final UpdateOptions options;
    private Document filter;
    private Document update;
    private Document hint;
    private Document variables;
    private boolean updateMany;

    public UpdateBuilder(MongoApplicationSupport application, String collection) {
        this.application = application;
        this.collection = collection;
        this.update = new Document();
        this.options = new UpdateOptions();
        this.filter = new Document();
        this.hint = new Document();
        this.variables = new Document();
    }

    public UpdateBuilder filter(Document filter) {
        this.filter.putAll((Map)filter);
        return this;
    }

    public UpdateBuilder filter(String key, Object value) {
        this.filter.put(key, value);
        return this;
    }

    public UpdateBuilder update(Document update) {
        this.update.putAll((Map)update);
        return this;
    }

    public UpdateBuilder update(String key, Object value) {
        this.update.put(key, value);
        return this;
    }

    public UpdateBuilder upsert(boolean upsert) {
        this.options.upsert(upsert);
        return this;
    }

    public UpdateBuilder updateMany(boolean updateMany) {
        this.updateMany = updateMany;
        return this;
    }

    public UpdateBuilder collation(Collation collation) {
        this.options.collation(collation);
        return this;
    }

    public UpdateBuilder bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.options.bypassDocumentValidation(Boolean.valueOf(bypassDocumentValidation));
        return this;
    }

    public UpdateBuilder hint(Document hint) {
        this.hint.putAll((Map)hint);
        return this;
    }

    public UpdateBuilder hint(String key, Object value) {
        this.hint.put(key, value);
        return this;
    }

    public UpdateBuilder hintString(String hintString) {
        this.options.hintString(hintString);
        return this;
    }

    public UpdateBuilder comment(String comment) {
        this.options.comment(comment);
        return this;
    }

    public UpdateBuilder let(Document variables) {
        this.variables.putAll((Map)variables);
        return this;
    }

    public UpdateBuilder let(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public UpdateResponse execute() {
        Document updateDocument = new Document().append("$set", (Object)this.update);
        return this.application.update(this.filter.toJson(), updateDocument.toJson(), this.serializeOptions(), this.collection, this.updateMany);
    }

    private Map<String, String> serializeOptions() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("upsert", String.valueOf(this.options.isUpsert()));
        optionsMap.put("bypassDocumentValidation", this.options.getBypassDocumentValidation() == null ? null : String.valueOf(this.options.getBypassDocumentValidation()));
        optionsMap.put("collation", this.options.getCollation() == null ? null : this.options.getCollation().asDocument().toJson());
        optionsMap.put("hintString", this.options.getHintString());
        optionsMap.put("hint", this.hint.isEmpty() ? null : this.hint.toJson());
        optionsMap.put("comment", this.options.getComment() == null ? null : this.options.getComment().toString());
        optionsMap.put("variables", this.variables.isEmpty() ? null : this.variables.toJson());
        return optionsMap;
    }
}

