/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.ocr;

import java.util.ArrayList;
import java.util.Map;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.remote.Response;

public class OcrResponse {
    protected final long status;
    protected final String message;
    protected final Object capabilities;
    protected final Coordinates topLeftPoint;
    protected final Coordinates bottomRightPoint;
    protected final Response delegate;

    public OcrResponse(Response delegate) {
        if (delegate == null || delegate.getValue() == null) {
            throw new IllegalArgumentException();
        }
        Map delegateValue = (Map)delegate.getValue();
        if (delegate.getStatus() == null) {
            throw new NotFoundException("Image not found.");
        }
        this.delegate = delegate;
        this.status = delegate.getStatus().intValue();
        this.message = (String)delegateValue.get("message");
        this.capabilities = delegateValue.get("capabilities");
        Map result = (Map)delegateValue.get("result");
        this.topLeftPoint = new Coordinates((ArrayList)result.get("top_left_point"));
        this.bottomRightPoint = new Coordinates((ArrayList)result.get("bottom_right_point"));
    }

    public Coordinates buttonCenter() {
        return new Coordinates(this.topLeftPoint.x - this.bottomRightPoint.x, this.topLeftPoint.y - this.bottomRightPoint.y);
    }

    public class Coordinates {
        protected final long x;
        protected final long y;

        public Coordinates(ArrayList<Long> array) {
            this.x = array.get(0);
            this.y = array.get(1);
        }

        public Coordinates(long x, long y) {
            this.x = x;
            this.y = y;
        }

        public long x() {
            return this.x;
        }

        public long y() {
            return this.y;
        }
    }
}

