/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.ocr;

import dev.pumpo5.config.Config;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.ocr.OcrAgent;
import dev.pumpo5.remote.ocr.OcrResponse;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class RemoteOcrAgent
extends AbstractRemoteDriverAgent
implements OcrAgent {
    protected static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>(){
        {
            this.put(WebdriverSubUrl.find_sub_image.name(), new CommandInfo(RemoteOcrAgent.ocrWebdriverUrl + WebdriverSubUrl.find_sub_image.name(), HttpMethod.POST));
        }
    };
    protected static final String ocrWebdriverUrl = "/session/:sessionId/pn5-ocr/";

    public RemoteOcrAgent(Logger logger, Config config, Map<String, Object> capabilities, String farmUrl) {
        super(logger, config, capabilities, farmUrl);
    }

    @Override
    public OcrResponse findImage(byte[] image, byte[] imageToFind) {
        final ByteToJSON encodedImage = new ByteToJSON(image, JsonKeys.image_base64.name());
        final ByteToJSON encodedImageToFind = new ByteToJSON(imageToFind, JsonKeys.sub_image_base64.name());
        final HashMap<String, String> payload = new HashMap<String, String>(){
            {
                this.put(encodedImage.jsonKey(), encodedImage.jsonValue());
                this.put(encodedImageToFind.jsonKey(), encodedImageToFind.jsonValue());
            }
        };
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("payload", payload);
            }
        };
        Response response = this.driver.execute(WebdriverSubUrl.find_sub_image.name(), map);
        return new OcrResponse(response);
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    protected class ByteToJSON {
        protected final String jsonKey;
        protected final String jsonValue;

        public ByteToJSON(byte[] image, String tag) {
            this.jsonKey = tag;
            this.jsonValue = Base64.getEncoder().encodeToString(image);
        }

        public String jsonKey() {
            return this.jsonKey;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    protected static enum JsonKeys {
        image_base64,
        sub_image_base64;

    }

    protected static enum WebdriverSubUrl {
        find_sub_image;

    }
}

