/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.restassured;

import dev.pumpo5.core.LogLevel;
import dev.pumpo5.remote.http.HttpResponse;
import dev.pumpo5.remote.restassured.RestAssuredApplicationSupport;
import io.restassured.builder.ResponseBuilder;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.http.ContentType;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.internal.NameAndValue;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class PumpoFilter
implements OrderedFilter {
    private RestAssuredApplicationSupport restAssuredApplicationSupport;

    public PumpoFilter(RestAssuredApplicationSupport restAssuredApplicationSupport) {
        this.restAssuredApplicationSupport = restAssuredApplicationSupport;
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        boolean issueDirectCall = this.restAssuredApplicationSupport.getConfig().getOrDefault((Object)"pn5.restassured.direct", false);
        if (issueDirectCall) {
            this.restAssuredApplicationSupport.getLogger().log(LogLevel.INFO, "Pumpo 5 is configured to issue Rest Assured calls directly (bypassing pn5 driver)", new Object[0]);
            return ctx.next(requestSpec, responseSpec);
        }
        HttpResponse httpResponse = this.restAssuredApplicationSupport.request(requestSpec.getURI(), requestSpec.getMethod(), this.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getHeaders()), (String)requestSpec.getBody());
        List headers = httpResponse.headers.entrySet().stream().map(item -> new Header((String)item.getKey(), (String)item.getValue())).collect(Collectors.toList());
        ResponseBuilder responseBuilder = new ResponseBuilder().setStatusCode(httpResponse.status).setHeaders(new Headers(headers)).setBody(httpResponse.payload);
        headers.stream().filter(header -> header.getName().toLowerCase(Locale.ROOT).startsWith("content-type")).findFirst().ifPresent(header -> responseBuilder.setContentType(ContentType.fromContentType((String)header.getValue())));
        return responseBuilder.build();
    }

    private Map<String, String> toMapConverter(Iterable<? extends NameAndValue> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach(h -> result.put(h.getName(), h.getValue()));
        return result;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

