/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.restassured;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.remote.http.HttpAgent;
import dev.pumpo5.remote.http.HttpAgentSupport;
import dev.pumpo5.remote.http.HttpResponse;
import dev.pumpo5.remote.restassured.PumpoFilter;
import dev.pumpo5.remote.restassured.RestAssuredApplication;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.specification.RequestSpecification;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.remote.Response;

public class RestAssuredApplicationSupport
extends ApplicationSupport<RestAssuredApplication>
implements RestAssuredApplication {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    protected HttpAgentSupport agent;

    public RestAssuredApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends RestAssuredApplication> APPLICATION_OBJECT createProxy(Class<? extends RestAssuredApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!RestAssuredApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend RestAssuredApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((RestAssuredApplication)Proxy.newProxyInstance(HttpAgent.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<RestAssuredApplicationSupport>(type, new RestAssuredApplicationSupport(core, driverUrl, capabilities))));
    }

    @Override
    public HttpAgentSupport newAgent() {
        return new HttpAgentSupport(this.getLogger(), this.getConfig(), this.capabilities, this.driverUrl);
    }

    @Override
    public HttpAgentSupport agent() {
        return this.agent;
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public RequestSpecification withPumpo() {
        RequestSpecification requestSpecification = RestAssured.with();
        List restAssuredFilters = (List)this.getGlobalStore().get("dev.pumpo5.restAssuredFilters");
        if (restAssuredFilters != null) {
            requestSpecification.filters(restAssuredFilters);
        }
        requestSpecification.filter((Filter)new PumpoFilter(this));
        return requestSpecification;
    }

    public HttpResponse request(String url, String method, Map<String, String> headers, String payload) {
        this.checkSessionStarted();
        Response response = this.agent.getWebDriverResponse(url, method, headers, null, null, null, null, null, null, null, null, payload, false, 60);
        try {
            return (HttpResponse)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(response.getValue()), HttpResponse.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while parsing the response received by the the remote http agent after sending a request to url " + url + " with method " + method + ", exception thrown by our response parser is: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

