/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.samba;

import dev.pumpo5.PumpoException;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.samba.SambaAgentSupport;
import dev.pumpo5.remote.samba.SambaApplication;
import dev.pumpo5.remote.samba.SambaListResponse;
import dev.pumpo5.remote.samba.SambaReadResponse;
import dev.pumpo5.remote.samba.SambaResponse;
import dev.pumpo5.remote.samba.SambaWriteResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.util.Map;

public class SambaApplicationSupport
extends ApplicationSupport<SambaApplication>
implements SambaApplication {
    protected SambaAgentSupport agent;

    public SambaApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends SambaApplication> APPLICATION_OBJECT createProxy(Class<? extends SambaApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!SambaApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend SambaApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((SambaApplication)Proxy.newProxyInstance(SambaAgentSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<SambaApplicationSupport>(type, new SambaApplicationSupport(core, driverUrl, capabilities))));
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    public SambaAgentSupport newAgent() {
        return new SambaAgentSupport(this, this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public SambaListResponse listFiles(String folder) {
        this.checkSessionStarted();
        return this.agent.listFiles(folder);
    }

    @Override
    public SambaWriteResponse createFolder(String folder) {
        this.checkSessionStarted();
        return this.agent.createFolder(folder);
    }

    @Override
    public SambaResponse deleteFolder(String folder, boolean recursive) {
        this.checkSessionStarted();
        return this.agent.deleteFolder(folder, recursive);
    }

    @Override
    public SambaWriteResponse writeFile(File file, String fileName) {
        FileInputStream fileStream;
        this.checkSessionStarted();
        try {
            fileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger logger = this.getLogger();
            String message = String.format("File %s was not found", file);
            logger.log(LogLevel.ERROR, message, new Object[0]);
            logger.log(LogLevel.ERROR, e.getMessage(), new Object[0]);
            throw new PumpoException(message, e);
        }
        return this.writeFile(fileStream, fileName);
    }

    @Override
    public SambaWriteResponse writeFile(InputStream fileStream, String fileName) {
        this.checkSessionStarted();
        return this.agent.writeFile(fileStream, fileName);
    }

    @Override
    public SambaReadResponse readFile(String file) {
        this.checkSessionStarted();
        return this.agent.readFile(file);
    }

    @Override
    public SambaWriteResponse moveFile(String oldFile, String newFile) {
        this.checkSessionStarted();
        return this.agent.moveFile(oldFile, newFile);
    }

    @Override
    public SambaResponse deleteFile(String file) {
        this.checkSessionStarted();
        return this.agent.deleteFile(file);
    }
}

