/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.samba;

import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.samba.SambaResponse;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class SambaListResponse
extends SambaResponse {
    public Collection<Map<String, Object>> filesAndFolders;

    public SambaListResponse printFilesInformation() {
        this.filesAndFolders.forEach(file -> this.sambaApplication.getLogger().log(LogLevel.INFO, "name: {}, size: {} bytes, creation time: {}, modification time: {}, last access time: {}, last write time: {}", file.get("name"), file.get("size").toString(), file.get("creationTime").toString(), file.get("modificationTime").toString(), file.get("lastAccessTime").toString(), file.get("lastWriteTime").toString()));
        return this;
    }

    public Collection<Map<String, Object>> getFilesAndFolders() {
        return this.filesAndFolders;
    }

    public SambaListResponse assertThatContainsFileOrFolderNamed(String fileOrFolder) {
        Asserts.assertContains(this.getFileNames(), fileOrFolder);
        return this;
    }

    public SambaListResponse assertThatDoesNotContainFileOrFolderNamed(String fileOrFolder) {
        Asserts.assertDoesNotContain(this.getFileNames(), fileOrFolder);
        return this;
    }

    private Collection<String> getFileNames() {
        return this.filesAndFolders.stream().map(file -> file.get("name").toString()).collect(Collectors.toList());
    }
}

