/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.samba;

import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.samba.SambaResponse;
import java.util.Date;

public class SambaReadResponse
extends SambaResponse {
    public byte[] fileContent;
    public String name;
    public Date creationTime;
    public Date modificationTime;
    public Date lastAccessTime;
    public Date lastWriteTime;

    public SambaReadResponse printFileInformation() {
        this.sambaApplication.getLogger().log(LogLevel.INFO, "name: {}, size: {} bytes, creation time: {}, modification time: {}, last access time: {}, last write time: {}", this.name, this.fileContent.length, this.creationTime, this.modificationTime, this.lastAccessTime, this.lastWriteTime);
        return this;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public SambaReadResponse assertFileSizeInBytes(long fileSizeInBytes) {
        Asserts.assertTrue(String.format("File size is different. Expected: %d bytes, Actual: %d bytes", fileSizeInBytes, this.fileContent.length), (long)this.fileContent.length == fileSizeInBytes);
        return this;
    }
}

