/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sftp;

import dev.pumpo5.config.Config;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.util.ResolutionUtils;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.sftp.SftpAgent;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class RemoteSftpAgent
extends AbstractRemoteDriverAgent
implements SftpAgent {
    private static final String DOWNLOAD_COMMAND = "download";
    private static final String GET_TYPE_COMMAND = "get_type";
    private static final String LIST_COMMAND = "ls";
    private static final String LSTAT_COMMAND = "lstat";
    private static final String MKDIR_COMMAND = "mkdir";
    private static final String RENAME_COMMAND = "rename";
    private static final String REMOVE_COMMAND = "rm";
    private static final String REMOVE_DIR_COMMAND = "rmdir";
    private static final String UPLOAD_COMMAND = "upload";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>(){
        {
            this.put(RemoteSftpAgent.DOWNLOAD_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/download", HttpMethod.POST));
            this.put(RemoteSftpAgent.UPLOAD_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/upload", HttpMethod.POST));
            this.put(RemoteSftpAgent.LIST_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/ls", HttpMethod.POST));
            this.put(RemoteSftpAgent.LSTAT_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/lstat", HttpMethod.POST));
            this.put(RemoteSftpAgent.MKDIR_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/mkdir", HttpMethod.POST));
            this.put(RemoteSftpAgent.RENAME_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/rename", HttpMethod.POST));
            this.put(RemoteSftpAgent.REMOVE_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/rm", HttpMethod.POST));
            this.put(RemoteSftpAgent.REMOVE_DIR_COMMAND, new CommandInfo("/session/:sessionId/pn5-sftp/rmdir", HttpMethod.POST));
        }
    };

    public RemoteSftpAgent(Logger logger, Config config, Map<String, Object> capabilities, String farmUrl) {
        super(logger, config, capabilities, farmUrl);
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    @Override
    public void download(String remotePath, String localPath) {
        Response response = this.driver.execute(DOWNLOAD_COMMAND, Collections.singletonMap("path", remotePath));
        byte[] bytes = Base64.getDecoder().decode((String)response.getValue());
        try {
            FileUtils.writeByteArrayToFile((File)new File(localPath), (byte[])bytes);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to write bytes to file %s", remotePath), e);
        }
    }

    @Override
    public List<String> list(String remotePath) {
        Response response = this.driver.execute(LIST_COMMAND, Collections.singletonMap("path", remotePath));
        return Optional.ofNullable(response.getValue()).filter(List.class::isInstance).map(List.class::cast).orElseThrow(() -> new AssertionError((Object)String.format("expected a list of string but got: '%s'", response.getValue().toString())));
    }

    @Override
    public String lstat(String remotePath) {
        Response response = this.driver.execute(LSTAT_COMMAND, Collections.singletonMap("path", remotePath));
        return Optional.ofNullable(response.getValue()).map(Object::toString).orElseThrow(() -> new AssertionError((Object)String.format("expected a list of string but got: '%s'", response.getValue().toString())));
    }

    @Override
    public void makeDirectory(String remotePath) {
        this.driver.execute(MKDIR_COMMAND, Collections.singletonMap("path", remotePath));
    }

    @Override
    public void rename(final String oldRemotePath, final String newRemotePath) {
        this.driver.execute(RENAME_COMMAND, new HashMap<String, Object>(){
            {
                this.put("oldPath", oldRemotePath);
                this.put("newPath", newRemotePath);
            }
        });
    }

    @Override
    public void remove(String remotePath) {
        this.driver.execute(REMOVE_COMMAND, Collections.singletonMap("path", remotePath));
    }

    @Override
    public void removeDirectory(String remotePath) {
        this.driver.execute(REMOVE_DIR_COMMAND, Collections.singletonMap("path", remotePath));
    }

    @Override
    public void upload(String pathOrString, final String remotePath) {
        String string = ResolutionUtils.resolvePathOrString(this.logger, this, pathOrString);
        final String encodedString = Base64.getEncoder().encodeToString(string.getBytes());
        this.driver.execute(UPLOAD_COMMAND, new HashMap<String, Object>(){
            {
                this.put("path", remotePath);
                this.put("contents", encodedString);
            }
        });
    }
}

