/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sftp;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.SessionManager;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.sftp.RemoteSftpAgent;
import dev.pumpo5.remote.sftp.SftpAgent;
import dev.pumpo5.remote.sftp.SftpApplication;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

public class SftpApplicationSupport
extends ApplicationSupport<SftpApplication>
implements SftpApplication,
SessionManager<SftpApplication> {
    private SftpAgent agent;

    public SftpApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends SftpApplication> APPLICATION_OBJECT createProxy(Class<? extends SftpApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!SftpApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend SftpApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((SftpApplication)Proxy.newProxyInstance(RemoteSftpAgent.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<SftpApplicationSupport>(type, new SftpApplicationSupport(core, driverUrl, capabilities))));
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    public RemoteSftpAgent newAgent() {
        return new RemoteSftpAgent(this.getLogger(), this.getConfig(), this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public void download(String remotePath, String localPath) {
        this.agent.download(remotePath, localPath);
    }

    @Override
    public List<String> list(String remotePath) {
        return this.agent.list(remotePath);
    }

    @Override
    public String lstat(String remotePath) {
        return this.agent.lstat(remotePath);
    }

    @Override
    public void makeDirectory(String remotePath) {
        this.agent.makeDirectory(remotePath);
    }

    @Override
    public void rename(String oldRemotePath, String newRemotePath) {
        this.agent.rename(oldRemotePath, newRemotePath);
    }

    @Override
    public void remove(String remotePath) {
        this.agent.remove(remotePath);
    }

    @Override
    public void removeDirectory(String remotePath) {
        this.agent.removeDirectory(remotePath);
    }

    @Override
    public void upload(String pathOrString, String remotePath) {
        this.agent.upload(pathOrString, remotePath);
    }
}

