/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.sql.SqlResponse;
import dev.pumpo5.remote.sql.TimeDeserializers;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.Response;

public class SelectResponse
extends SqlResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private long rowCount;
    private List<JsonNode> rows;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        this.rowCount = json.at("/value/body/num_rows").asLong();
        this.rows = this.toRows(response);
    }

    private List<JsonNode> toRows(Response response) {
        List columns = StreamSupport.stream(MAPPER.valueToTree((Object)response).at("/value/body/columns").spliterator(), false).map(JsonNode::textValue).collect(Collectors.toList());
        List unorderedRows = StreamSupport.stream(MAPPER.valueToTree((Object)response).at("/value/body/rows").spliterator(), false).map(r -> IntStream.range(0, columns.size()).boxed().collect(Collectors.collectingAndThen(Collectors.toMap(columns::get, arg_0 -> ((JsonNode)r).get(arg_0)), m -> new ObjectNode(JsonNodeFactory.instance, m)))).collect(Collectors.toList());
        ArrayList<JsonNode> orderedRows = new ArrayList<JsonNode>();
        for (ObjectNode node : unorderedRows) {
            ObjectNode newOrderedRow = new ObjectNode(JsonNodeFactory.instance);
            for (String column : columns) {
                newOrderedRow.set(column, node.get(column));
            }
            orderedRows.add((JsonNode)newOrderedRow);
        }
        return orderedRows;
    }

    public SelectResponse assertThatRowCountIs(long expectedRowCount) {
        Asserts.assertEquals(expectedRowCount, this.rowCount, "rows");
        return this;
    }

    public <PoJo> List<PoJo> rowsAsListOf(Class<PoJo> pojoClass) {
        return this.rows.stream().map(row -> {
            try {
                return MAPPER.treeToValue((TreeNode)row, pojoClass);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
    }

    public long rowCount() {
        return this.rowCount;
    }

    public List<JsonNode> rowsAsListOfJsonNodes() {
        return this.rows;
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)new TimeDeserializers.DateDeserializer());
        javaTimeModule.addDeserializer(Time.class, (JsonDeserializer)new TimeDeserializers.TimeDeserializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimeDeserializers.TimestampDeserializer());
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)javaTimeModule).registerModule((Module)new JodaModule());
    }
}

