/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.sql.SelectResponse;
import dev.pumpo5.remote.sql.SqlAgent;
import dev.pumpo5.remote.sql.SqlApplication;
import dev.pumpo5.remote.sql.SqlResponse;
import dev.pumpo5.remote.sql.UpdateResponse;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class SqlAgentSupport
extends AbstractRemoteDriverAgent
implements SqlAgent {
    private static final String QUERY = "sql_query";
    private static final String UPDATE = "sql_update";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>();
    private static final ObjectMapper MAPPER;
    SqlApplication sqlApplication;

    public SqlAgentSupport(SqlApplication sqlApplication, Map<String, Object> capabilities, String farmUrl) {
        super(sqlApplication.getLogger(), sqlApplication.getConfig(), capabilities, farmUrl);
        this.sqlApplication = sqlApplication;
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    @Override
    public SelectResponse query(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "query");
        params.put("query", query);
        Response response = this.driver.execute(QUERY, params);
        return this.parseResponse(response, SelectResponse.class);
    }

    @Override
    public UpdateResponse update(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "update");
        params.put("update", query);
        Response response = this.driver.execute(UPDATE, params);
        return this.parseResponse(response, UpdateResponse.class);
    }

    private <T extends SqlResponse> T parseResponse(Response response, Class<T> clazz) {
        if (response == null) {
            throw new IllegalStateException("Failed to get a valid response from the remote driver");
        }
        try {
            SqlResponse parsedResponse = (SqlResponse)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(response.getValue()), clazz);
            parsedResponse.setFullResponse(response);
            parsedResponse.sqlApplication = this.sqlApplication;
            return (T)parsedResponse;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ADDITIONAL_COMMANDS.put(QUERY, new CommandInfo("/session/:sessionId/pn5-sql/execute", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(UPDATE, new CommandInfo("/session/:sessionId/pn5-sql/execute", HttpMethod.POST));
        MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

