/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sql;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.SessionManager;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.sql.SelectQueryBuilder;
import dev.pumpo5.remote.sql.SelectResponse;
import dev.pumpo5.remote.sql.SqlAgentSupport;
import dev.pumpo5.remote.sql.SqlApplication;
import dev.pumpo5.remote.sql.SqlReporter;
import dev.pumpo5.remote.sql.UpdateQueryBuilder;
import dev.pumpo5.remote.sql.UpdateResponse;
import java.lang.reflect.Proxy;
import java.util.Map;

public class SqlApplicationSupport
extends ApplicationSupport<SqlApplication>
implements SqlApplication,
SessionManager<SqlApplication> {
    protected SqlAgentSupport agent;
    protected SqlReporter sqlReporter;

    public SqlApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
        this.prepareReporting();
    }

    public static <APPLICATION_OBJECT extends SqlApplication> APPLICATION_OBJECT createProxy(Class<? extends SqlApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!SqlApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend SqlApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((SqlApplication)Proxy.newProxyInstance(SqlAgentSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<SqlApplicationSupport>(type, new SqlApplicationSupport(core, driverUrl, capabilities))));
    }

    private void prepareReporting() {
        this.sqlReporter = (SqlReporter)this.getGlobalStore().get("dev.pumpo5.sqlFilter");
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    public SqlAgentSupport newAgent() {
        return new SqlAgentSupport(this, this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public SelectQueryBuilder prepareQuery(String query) {
        return new SelectQueryBuilder(this, query);
    }

    @Override
    public UpdateQueryBuilder prepareUpdate(String query) {
        return new UpdateQueryBuilder(this, query);
    }

    SelectResponse query(String query) {
        this.checkSessionStarted();
        try {
            SelectResponse selectResponse = this.agent.query(query);
            if (this.sqlReporter != null) {
                this.sqlReporter.reportSelect(query, selectResponse);
            }
            return selectResponse;
        }
        catch (Throwable t) {
            if (this.sqlReporter != null) {
                this.sqlReporter.reportSelect(query, null);
            }
            throw t;
        }
    }

    UpdateResponse update(String query) {
        this.checkSessionStarted();
        try {
            UpdateResponse updateResponse = this.agent.update(query);
            if (this.sqlReporter != null) {
                this.sqlReporter.reportUpdate(query, updateResponse);
            }
            return updateResponse;
        }
        catch (Throwable t) {
            if (this.sqlReporter != null) {
                this.sqlReporter.reportUpdate(query, null);
            }
            throw t;
        }
    }
}

