/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sql;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimeDeserializers {
    public static Date getDate(String input) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
        return Date.from(Instant.from(dateTimeFormatter.parse(input)));
    }

    public static String getInput(JsonParser jsonParser) throws IOException {
        ObjectNode node = (ObjectNode)jsonParser.readValueAsTree();
        return ((JsonNode)node.elements().next()).asText();
    }

    public static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        public Timestamp deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String input = TimeDeserializers.getInput(jsonParser);
            return new Timestamp(TimeDeserializers.getDate(input).getTime());
        }
    }

    public static class DateDeserializer
    extends JsonDeserializer<java.sql.Date> {
        public java.sql.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String input = TimeDeserializers.getInput(jsonParser);
            return new java.sql.Date(TimeDeserializers.getDate(input).getTime());
        }
    }

    public static class TimeDeserializer
    extends JsonDeserializer<Time> {
        public Time deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String input = TimeDeserializers.getInput(jsonParser);
            return Time.valueOf(LocalTime.parse(input));
        }
    }
}

