/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.sql;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.sql.SqlResponse;
import org.openqa.selenium.remote.Response;

public class UpdateResponse
extends SqlResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private long rowsAffected;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        this.rowsAffected = json.at("/value/affectedCount").asLong();
    }

    public UpdateResponse assertThatRowCountIs(long expectedRowCount) {
        Asserts.assertEquals(expectedRowCount, this.rowsAffected, "rows affected");
        return this;
    }

    public long rowsAffected() {
        return this.rowsAffected;
    }
}

