/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.reporting;

import com.google.common.io.Files;
import dev.pumpo5.Utils;
import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.reporting.FailureMode;
import dev.pumpo5.reporting.InputStreamWrapper;
import dev.pumpo5.reporting.ReportTo;
import dev.pumpo5.reporting.Reporter;
import dev.pumpo5.reporting.spi.ReporterSPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class AggregatingReporter
implements Reporter {
    protected PumpoEvents logger = new PumpoEvents();
    protected Config config;
    final List<ReporterSPI> reporters = new ArrayList<ReporterSPI>();
    ExtensionContext extensionContext;
    boolean testSuiteStarted = false;
    boolean testCaseStarted = false;
    boolean testCaseCompleted = false;
    Integer currentStep;
    boolean stepStarted = false;
    boolean haltOnError;
    int stepsSkipped = 0;
    int stepsPassed = 0;
    int stepsFailed = 0;
    FailureMode testcaseFailureMode;
    protected Reporter.TestcaseResult testcaseResult = Reporter.TestcaseResult.PASSED_UNTIL_FAILURE;
    protected Reporter.StepFailureBehaviour defaultStepFailureBehaviour;
    protected Reporter.StepFailureBehaviour currentStepFailureBehaviour;
    protected Throwable mainFailureCause = null;
    boolean autostartTestcase = true;
    boolean autostartStep = true;
    Throwable failureCause;
    String displayId;
    int numberOfSteps;

    public AggregatingReporter() {
    }

    public AggregatingReporter(List<ReporterSPI> reporters) {
        this.reporters.addAll(reporters);
    }

    public void init(ExtensionContext extensionContext, String configPrefix) {
        this.config = new Config(ConfigHelper.getConfig(extensionContext), configPrefix);
        this.extensionContext = extensionContext;
        this.haltOnError = this.config.getOrDefault((Object)"pn5.reporting.haltOnError", false);
        this.autostartTestcase = this.getAutostartTestcase(extensionContext, this.config);
        this.autostartStep = this.getAutostartStep(extensionContext, this.config);
        this.testcaseFailureMode = this.testcaseFailureMode == null ? this.getTestcaseFailureMode(extensionContext, this.config) : this.testcaseFailureMode;
        this.defaultStepFailureBehaviour = this.defaultStepFailureBehaviour == null ? this.getTeststepFailureMode(extensionContext, this.config) : this.defaultStepFailureBehaviour;
        this.displayId = extensionContext.getDisplayName();
        this.numberOfSteps = this.setNumberOfSteps();
        if (this.autostartTestcase) {
            if (extensionContext.getTestMethod().isEmpty()) {
                this.startTestSuite();
            } else {
                this.startTestcase();
            }
        }
        this.logger.log(LogLevel.DEBUG, "Aggregating reporter '{}' initialized. Child reporters: {}", this.displayId(), this.reporters.stream().map(ReporterSPI::getName).toArray());
    }

    private Reporter.StepFailureBehaviour getTeststepFailureMode(ExtensionContext extensionContext, Config config) {
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), ReportTo.class);
        return optionalAnnotation.map(ReportTo::stepFailureMode).orElse(Reporter.StepFailureBehaviour.STOP_AS_FAILED);
    }

    boolean getAutostartTestcase(ExtensionContext extensionContext, Config config) {
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), ReportTo.class);
        return optionalAnnotation.map(ReportTo::autostartTestcase).orElse(true);
    }

    boolean getAutostartStep(ExtensionContext extensionContext, Config config) {
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), ReportTo.class);
        return optionalAnnotation.map(ReportTo::autostartStep).orElse(true);
    }

    FailureMode getTestcaseFailureMode(ExtensionContext extensionContext, Config config) {
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), ReportTo.class);
        return optionalAnnotation.map(ReportTo::testcaseFailureMode).orElse(FailureMode.STOP);
    }

    @Override
    public void startTestSuite() {
        if (!this.testSuiteStarted) {
            this.reporters.forEach(ReporterSPI::startTestSuite);
            this.testSuiteStarted = true;
        }
    }

    @Override
    public void completeTestSuite() {
        this.reporters.forEach(ReporterSPI::completeTestSuite);
        this.testSuiteStarted = false;
    }

    @Override
    public Reporter startTestcase() {
        return this.startTestcase(this.testcaseFailureMode, this.defaultStepFailureBehaviour);
    }

    @Override
    public Reporter startTestcase(FailureMode testcaseFailureMode, Reporter.StepFailureBehaviour stepFailureBehaviour) {
        this.testcaseFailureMode = testcaseFailureMode;
        this.defaultStepFailureBehaviour = stepFailureBehaviour;
        String testCaseName = (String)this.extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"testCaseName");
        if (testCaseName == null) {
            return this;
        }
        if (this.testCaseStarted) {
            this.logger.log(LogLevel.DEBUG, "Test case reporting already started", new Object[0]);
        } else {
            this.logger.log(LogLevel.INFO, "Starting test case reporting", new Object[0]);
            this.reporters.forEach(reporterSPI -> {
                if (reporterSPI.numberOfSteps() > 0) {
                    reporterSPI.markStepsAsPending();
                }
            });
            this.reporters.forEach(reporterSPI -> {
                if (!reporterSPI.markTestAsStarted()) {
                    if (this.haltOnError) {
                        throw new IllegalStateException(Utils.mFormat("Reporter {} failed to start test {} for unknown reason. Check the reporter logs", reporterSPI.getName(), reporterSPI.getTestcaseKey()));
                    }
                    this.logger.log(LogLevel.WARN, "Reporter {} failed to start test {} for unknown reason. Check the reporter logs", reporterSPI.getName(), reporterSPI.getTestcaseKey());
                }
            });
            this.reporters.forEach(reporterSPI -> reporterSPI.startTestcase(testCaseName));
            this.testCaseStarted = true;
            if (this.numberOfSteps > 0 && this.autostartStep) {
                this.startStep();
            } else {
                this.logger.log(LogLevel.DEBUG, "The test {} has no steps", this.displayId());
            }
        }
        return this;
    }

    private int setNumberOfSteps() {
        for (int i = 0; i < this.reporters.toArray().length; ++i) {
            if (this.reporters.get(i).numberOfSteps() <= 0) continue;
            return this.reporters.get(i).numberOfSteps();
        }
        return 0;
    }

    @Override
    public Reporter startTestcase(String key, FailureMode testcaseFailureMode, Reporter.StepFailureBehaviour stepFailureBehaviour) {
        throw new UnsupportedOperationException("Reporting to single test case by key is not supported yet");
    }

    @Override
    public Reporter startStep() {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot start step: there is not test case report running");
        }
        if (this.stepStarted) {
            throw new IllegalStateException("Cannot start step: there is a step already running and substeps are not supported");
        }
        if (this.currentStep == null) {
            this.currentStep = 0;
        } else {
            Integer n = this.currentStep;
            this.currentStep = this.currentStep + 1;
        }
        if (this.currentStep < this.numberOfSteps) {
            this.reporters.forEach(reporterSPI -> reporterSPI.markStepAsStarted(this.currentStep));
            this.stepStarted = true;
            this.currentStepFailureBehaviour = this.defaultStepFailureBehaviour;
        }
        return this;
    }

    @Override
    public Reporter skipStep() {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot skip step: there is not test case report running");
        }
        if (!this.stepStarted) {
            throw new IllegalStateException("Cannot skip step: there is no test step started. Did you forget to start it explicitly?");
        }
        this.reporters.forEach(reporterSPI -> reporterSPI.markStepAsSkipped(this.currentStep));
        ++this.stepsSkipped;
        this.stepStarted = false;
        if (this.autostartStep) {
            this.startStep();
        }
        return this;
    }

    @Override
    public Reporter addComment(String comment) {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot add comment: there is not test case report running");
        }
        if (this.stepStarted) {
            this.reporters.forEach(reporter -> reporter.addComment(comment, this.currentStep));
        } else {
            this.reporters.forEach(reporter -> reporter.addComment(comment, null));
        }
        return this;
    }

    @Override
    public Reporter addThrowable(Throwable throwable) {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot add throwable: there is not test case report running");
        }
        if (this.stepStarted) {
            this.reporters.forEach(reporter -> reporter.addThrowable(throwable, this.currentStep));
        } else {
            this.reporters.forEach(reporter -> reporter.addThrowable(throwable, null));
        }
        return this;
    }

    @Override
    public Reporter attach(File file) {
        this.logger.log(LogLevel.DEBUG, "Attaching file {}", file.getName());
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot attach file: there is not test case report running");
        }
        try {
            this.attach(Files.getNameWithoutExtension((String)file.getName()), Files.getFileExtension((String)file.getName()), "application/octet-stream", new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot attach file", e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reporter attach(String name, String fileExtension, String type, InputStream stream) {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot add attachment: there is not test case report running");
        }
        InputStreamWrapper wrapper = new InputStreamWrapper(stream);
        try {
            this.reporters.forEach(reporter -> reporter.attach(name, fileExtension, type, wrapper, this.currentStep));
        }
        finally {
            try {
                wrapper.closeForReal();
            }
            catch (IOException iOException) {}
        }
        return this;
    }

    @Override
    public Reporter completeStepPassed() {
        return this.completeStepPassed(this.autostartStep);
    }

    Reporter completeStepPassed(boolean startNextStep) {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot complete step as passed: there is not test case report running");
        }
        if (this.numberOfSteps > 0) {
            if (!this.stepStarted) {
                throw new IllegalStateException("Cannot complete step as passed: there is no test step started. Did you forget to start it explicitly?");
            }
            this.reporters.forEach(reporterSPI -> reporterSPI.markStepAsPassed(this.currentStep));
            ++this.stepsPassed;
            this.stepStarted = false;
            if (startNextStep) {
                this.startStep();
            }
        } else {
            this.logger.log(LogLevel.DEBUG, "Cannot complete test step as passed: this test case has no steps.", new Object[0]);
        }
        return this;
    }

    @Override
    public Reporter completeStepFailed() throws Throwable {
        return this.completeStepFailed(this.autostartStep);
    }

    Reporter completeStepFailed(boolean startNextStep) throws Throwable {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot complete step as failed: there is not test case report running");
        }
        if (this.numberOfSteps > 0) {
            if (!this.stepStarted) {
                throw new IllegalStateException("Cannot complete step as failed: there is no test step started. Did you forget to start it explicitly?");
            }
            this.doCompleteStepFailed();
            this.evaluateActionAfterStepFailure(new Throwable(Utils.mFormat("Test case failed: {} steps passed, {} steps failed, {} steps skipped. First exception encountered: ", this.stepsPassed, this.stepsFailed, this.stepsSkipped)));
            if (startNextStep) {
                this.startStep();
            }
        } else {
            this.logger.log(LogLevel.DEBUG, "Cannot complete test step as failed: this test case has no steps.", new Object[0]);
        }
        return this;
    }

    void doCompleteStepFailed() {
        this.reporters.forEach(reporterSPI -> reporterSPI.markStepAsFailed(this.currentStep));
        ++this.stepsFailed;
        this.stepStarted = false;
    }

    @Override
    public Reporter completeTestcasePassed() {
        String testCaseName = (String)this.extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"testCaseName");
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot complete test case as passed: there is not test case report running");
        }
        this.reporters.forEach(reporterSPI -> reporterSPI.completeTestcase(testCaseName));
        if (this.stepStarted) {
            this.completeStepPassed(false);
        }
        this.reporters.forEach(ReporterSPI::markTestAsPassed);
        this.resetTestcase();
        return this;
    }

    @Override
    public Reporter completeTestcaseFailed() {
        this.doCompleteTestcaseFailed();
        if (this.mainFailureCause != null && this.testcaseFailureMode == FailureMode.STOP) {
            throw new Error(Utils.mFormat("Test case failed: {} steps passed, {} steps failed, {} steps skipped. First exception encountered: ", this.stepsPassed, this.stepsFailed, this.stepsSkipped), this.mainFailureCause);
        }
        this.testcaseResult = Reporter.TestcaseResult.FAILED;
        this.resetTestcase();
        return this;
    }

    void doCompleteTestcaseFailed() {
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot complete test case as failed: there is not test case report running");
        }
        if (this.stepStarted) {
            try {
                this.completeStepFailed(false);
            }
            catch (Throwable e) {
                throw new Error(e.getMessage() + (String)(this.mainFailureCause != null ? "\n" + this.mainFailureCause.getStackTrace() : ""));
            }
        }
        if (!this.testCaseCompleted) {
            this.reporters.forEach(ReporterSPI::markTestAsFailed);
            this.testCaseCompleted = true;
        }
    }

    void resetTestcase() {
        this.testCaseStarted = false;
        this.testCaseCompleted = false;
        this.currentStep = null;
        this.stepsFailed = 0;
        this.stepsPassed = 0;
        this.stepsSkipped = 0;
    }

    boolean hasTestcaseFailed() {
        return this.stepsFailed > 0;
    }

    @Override
    public Reporter completeTestcase() {
        if (this.testcaseResult == Reporter.TestcaseResult.FAILED) {
            return this.completeTestcaseFailed();
        }
        return this.completeTestcasePassed();
    }

    @Override
    public Reporter completeTestcase(String comment) {
        if (this.hasTestcaseFailed()) {
            return this.completeTestcaseFailed(comment);
        }
        return this.completeTestcasePassed(comment);
    }

    @Override
    public Reporter completeTestcasePassed(String comment) {
        this.completeTestcasePassed();
        this.reporters.forEach(reporterSPI -> reporterSPI.addComment(comment, null));
        return this;
    }

    @Override
    public Reporter completeTestcaseFailed(String comment) {
        this.doCompleteTestcaseFailed();
        this.reporters.forEach(reporterSPI -> reporterSPI.addComment(comment, null));
        if (this.testcaseFailureMode == FailureMode.STOP) {
            throw new AssertionError((Object)String.format("Test case failed: %s", comment));
        }
        this.resetTestcase();
        return this;
    }

    @Override
    public Reporter completeTestcaseFailed(Throwable cause, List<File> attachments) {
        this.logger.log(LogLevel.DEBUG, "Using aggregating reporter to complete test as failed with {} attachments.", attachments.size());
        String testCaseName = (String)this.extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"testCaseName");
        this.reporters.forEach(reporterSPI -> reporterSPI.completeTestcaseFailed(testCaseName));
        attachments.forEach(this::attach);
        if (this.failureCause != null && this.failureCause == cause) {
            this.failureCause = null;
            return this;
        }
        if (!this.testCaseStarted) {
            throw new IllegalStateException("Cannot complete test case as failed: there is not test case report running");
        }
        if (this.stepStarted) {
            if (cause != null) {
                this.addThrowable(cause);
            }
            this.doCompleteStepFailed();
        }
        this.reporters.forEach(ReporterSPI::markTestAsFailed);
        this.addThrowable(cause);
        this.resetTestcase();
        if (this.testcaseFailureMode == FailureMode.STOP) {
            this.failureCause = cause;
            throw new Error(Utils.mFormat("Test case failed: {} steps passed, {} steps failed, {} steps skipped. First exception encountered: {}", this.stepsPassed, this.stepsFailed, this.stepsSkipped, this.failureCause.getMessage()), this.failureCause);
        }
        return this;
    }

    private void evaluateActionAfterStepFailure(Throwable cause) throws Throwable {
        switch (this.currentStepFailureBehaviour) {
            case STOP_AS_FAILED: {
                this.completeTestcaseFailed();
                this.testCaseCompleted = true;
                throw cause;
            }
            case CONTINUE_AS_FAILED: {
                this.testcaseResult = Reporter.TestcaseResult.FAILED;
                break;
            }
            case CONTINUE_AS_PASSED: {
                this.testcaseResult = Reporter.TestcaseResult.PASSED;
                break;
            }
            case CONTINUE_AS_PASSED_UNTIL_FAILURE: {
                this.testcaseResult = Reporter.TestcaseResult.PASSED_UNTIL_FAILURE;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value in switch statement");
            }
        }
        if (this.mainFailureCause == null) {
            this.mainFailureCause = cause;
        }
    }

    @Override
    public Reporter setStepFailureBehaviour(Reporter.StepFailureBehaviour stepFailureBehaviour) {
        this.ensureTestcaseStarted();
        this.logger.log(LogLevel.TRACE, "Setting step {} behaviour for test {} to {}", new Object[]{this.currentStep, this.displayId(), stepFailureBehaviour});
        this.currentStepFailureBehaviour = stepFailureBehaviour;
        return this;
    }

    @Override
    public Reporter setStepFailureBehaviourDefault(Reporter.StepFailureBehaviour stepFailureBehaviour) {
        this.logger.log(LogLevel.TRACE, "Setting default behaviour for test {} to {}", new Object[]{this.displayId(), stepFailureBehaviour});
        this.defaultStepFailureBehaviour = stepFailureBehaviour;
        return this;
    }

    private void ensureTestcaseStarted() {
        if (!this.testCaseStarted) {
            this.startTestcase();
        }
    }

    protected String displayId() {
        return this.displayId;
    }

    public Reporter.TestcaseResult getResult() {
        return this.testcaseResult;
    }

    private void startStepIfExists() {
        if (this.currentStep < this.numberOfSteps) {
            this.currentStepFailureBehaviour = this.defaultStepFailureBehaviour;
            this.remoteStepSetStarted();
        }
    }

    private void remoteStepSetStarted() {
        this.reporters.forEach(reporterSPI -> reporterSPI.markStepAsStarted(this.currentStep));
    }

    public Reporter setResult(Reporter.TestcaseResult testcaseResult) {
        this.logger.log(LogLevel.TRACE, "Setting test {} result to {}", new Object[]{this.displayId(), testcaseResult});
        this.testcaseResult = testcaseResult;
        return this;
    }

    @Override
    public Reporter doAsSingleStep(Reporter.StepFailureBehaviour stepFailureBehaviour, Reporter.Flow flow) {
        block4: {
            this.setStepFailureBehaviour(stepFailureBehaviour);
            try {
                flow.execute();
                this.completeStepPassed();
            }
            catch (Throwable e) {
                try {
                    this.completeStepFailed(e);
                }
                catch (Throwable rethrown) {
                    if (rethrown == e) break block4;
                    throw new Error(rethrown);
                }
            }
        }
        return this;
    }
}

