/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.reporting;

import dev.pumpo5.reporting.FailureMode;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

public interface Reporter {
    public Reporter doAsSingleStep(StepFailureBehaviour var1, Flow var2);

    public void completeTestSuite();

    public void startTestSuite();

    public Reporter startTestcase();

    public Reporter startTestcase(FailureMode var1, StepFailureBehaviour var2);

    default public Reporter startTestcase(String key) {
        return this.startTestcase(key, FailureMode.STOP, StepFailureBehaviour.STOP_AS_FAILED);
    }

    default public Reporter startTestcase(String key, FailureMode testcaseFailureMode) {
        return this.startTestcase(key, testcaseFailureMode, StepFailureBehaviour.STOP_AS_FAILED);
    }

    public Reporter startTestcase(String var1, FailureMode var2, StepFailureBehaviour var3);

    public Reporter completeTestcasePassed();

    default public Reporter completeTestcasePassed(String comment) {
        this.addComment(comment);
        this.completeTestcasePassed();
        return this;
    }

    public Reporter completeTestcaseFailed() throws Throwable;

    default public Reporter completeTestcaseFailed(String comment) throws Throwable {
        this.addComment(comment);
        this.completeTestcaseFailed();
        return this;
    }

    default public Reporter completeTestcaseFailed(Throwable cause) throws Throwable {
        this.completeTestcaseFailed(cause, Collections.emptyList());
        return this;
    }

    default public Reporter completeTestcaseFailed(Throwable cause, List<File> attachments) throws Throwable {
        this.addThrowable(cause);
        this.completeTestcaseFailed();
        return this;
    }

    public Reporter completeTestcase();

    default public Reporter completeTestcase(String comment) {
        this.addComment(comment);
        this.completeTestcase();
        return this;
    }

    public Reporter setStepFailureBehaviour(StepFailureBehaviour var1);

    public Reporter setStepFailureBehaviourDefault(StepFailureBehaviour var1);

    public Reporter startStep();

    public Reporter skipStep();

    default public Reporter skipStep(String comment) {
        this.addComment(comment);
        this.skipStep();
        return this;
    }

    public Reporter completeStepPassed();

    default public Reporter completeStepPassed(String comment) {
        this.addComment(comment);
        this.completeStepPassed();
        return this;
    }

    public Reporter completeStepFailed() throws Throwable;

    default public Reporter completeStepFailed(String comment) throws Throwable {
        this.addComment(comment);
        this.completeStepFailed();
        return this;
    }

    default public Reporter completeStepFailed(Throwable cause) throws Throwable {
        this.addThrowable(cause);
        this.completeStepFailed();
        return this;
    }

    public Reporter addComment(String var1);

    public Reporter addThrowable(Throwable var1);

    public Reporter attach(File var1);

    public Reporter attach(String var1, String var2, String var3, InputStream var4);

    public static enum StepFailureBehaviour {
        STOP_AS_FAILED,
        CONTINUE_AS_PASSED_UNTIL_FAILURE,
        CONTINUE_AS_FAILED,
        CONTINUE_AS_PASSED;

    }

    @FunctionalInterface
    public static interface Flow {
        public void execute();
    }

    public static enum TestcaseResult {
        PASSED_UNTIL_FAILURE,
        PASSED,
        FAILED;

    }
}

