/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.reporting.junit;

import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.integrations.RecordVideoClient;
import dev.pumpo5.mobile.MobileApplication;
import dev.pumpo5.mobile.RemoteMobileAgent;
import dev.pumpo5.reporting.AggregatingReporter;
import dev.pumpo5.reporting.Reporter;
import dev.pumpo5.reporting.junit.JUnitReporterService;
import dev.pumpo5.reporting.junit.JUnitReporterStorageSupport;
import dev.pumpo5.web.RemoteWebAgent;
import dev.pumpo5.web.WebApplication;
import dev.pumpo5.win.WindowsAgent;
import dev.pumpo5.win.WindowsApplication;
import io.appium.java_client.AppiumDriver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.remote.RemoteWebDriver;

public class JUnitReportingExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private final Logger logger;
    Map<JUnitReporterService, JUnitReporterService> services;

    public JUnitReportingExtension() {
        ConcurrentHashMap<JUnitReporterService, JUnitReporterService> map = new ConcurrentHashMap<JUnitReporterService, JUnitReporterService>();
        ServiceLoader<JUnitReporterService> serviceLoader = ServiceLoader.load(JUnitReporterService.class);
        serviceLoader.forEach(reporterService -> map.put((JUnitReporterService)reporterService, (JUnitReporterService)reporterService));
        this.services = map;
        this.logger = new PumpoEvents();
    }

    public void beforeAll(ExtensionContext extensionContext) {
        try {
            this.prepareReporterFor(extensionContext);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Error preparing the reporter for the test suite: " + ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        Reporter reporterIn = JUnitReporterStorageSupport.findReporterIn(extensionContext);
        if (reporterIn != null) {
            reporterIn.startTestSuite();
        }
    }

    public void afterAll(ExtensionContext extensionContext) {
        Reporter reporterIn = JUnitReporterStorageSupport.findReporterIn(extensionContext);
        if (reporterIn != null) {
            reporterIn.completeTestSuite();
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        String testClassName = extensionContext.getTestClass().map(Class::getSimpleName).orElse("null_test_class");
        String testMethodName = extensionContext.getTestMethod().map(Method::getName).orElse("null_test_method");
        String testCaseName = testClassName + "#" + testMethodName;
        extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)"testCaseName", (Object)testCaseName);
        try {
            this.prepareReporterFor(extensionContext);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Error preparing the reporter for a test case: " + ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        Reporter reporterIn = JUnitReporterStorageSupport.findReporterIn(extensionContext);
        if (reporterIn != null) {
            reporterIn.startTestcase();
        }
    }

    public void afterEach(ExtensionContext extensionContext) {
        block7: {
            String testClassName = extensionContext.getTestClass().map(Class::getSimpleName).orElse("null_test_class");
            String testMethodName = extensionContext.getTestMethod().map(Method::getName).orElse("null_test_method");
            String testCaseName = testClassName + "#" + testMethodName;
            extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)"testCaseName", (Object)testCaseName);
            if (extensionContext.getExecutionException().isPresent()) {
                Throwable cause = (Throwable)extensionContext.getExecutionException().get();
                List<File> screenshots = this.logOrSaveScreenshotAndPageSource(extensionContext);
                this.logger.log(LogLevel.INFO, "Captured {} screenshots", screenshots.size());
                this.stopRecordingVideo(extensionContext);
                this.getDefaultContextPageSource(extensionContext);
                this.saveNetworkAndConsoleLogs(extensionContext);
                this.closeMobileDriver(extensionContext);
                try {
                    Reporter reporterIn = JUnitReporterStorageSupport.findReporterIn(extensionContext);
                    if (reporterIn != null) {
                        reporterIn.completeTestcaseFailed(cause, screenshots);
                        break block7;
                    }
                    this.logger.log(LogLevel.WARN, "Reporter is not found in the extension context", new Object[0]);
                }
                catch (Throwable replacement) {
                    this.logger.log(LogLevel.WARN, "Error completing the test case: {}", ExceptionUtils.getStackTrace((Throwable)replacement));
                    if (!(replacement instanceof Error) && cause != replacement && cause != replacement.getCause()) {
                        cause.addSuppressed(replacement);
                    }
                    break block7;
                }
            }
            Reporter reporterIn = JUnitReporterStorageSupport.findReporterIn(extensionContext);
            if (reporterIn != null) {
                reporterIn.completeTestcase();
            } else {
                this.logger.log(LogLevel.WARN, "Reporter is not found in the extension context", new Object[0]);
            }
        }
    }

    private void prepareReporterFor(ExtensionContext extensionContext) {
        AggregatingReporter reporter = new AggregatingReporter();
        if (Boolean.TRUE.equals(ConfigHelper.getBoolean(extensionContext, "pn5.reporting.enabled")) && !this.services.isEmpty()) {
            reporter = new AggregatingReporter(this.services.keySet().stream().map(service -> service.getReporter(extensionContext)).collect(Collectors.toList()));
        }
        JUnitReporterStorageSupport.storeReporter(extensionContext, reporter);
        reporter.init(extensionContext, "pn5");
    }

    @Deprecated(forRemoval=true)
    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        throw throwable;
    }

    private void saveNetworkAndConsoleLogs(ExtensionContext extensionContext) {
        ArrayList listOfTestProxies;
        Config config = ConfigHelper.getConfig(extensionContext);
        if (config.getBoolean("pn5.webdriver.browser.logs") && (listOfTestProxies = (ArrayList)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"dev.pumpo5.testProxiesKeyForLocalStore")) != null) {
            for (Object proxy : listOfTestProxies) {
                if (!(proxy instanceof WebApplication)) continue;
                RemoteWebAgent remoteWebAgent = (RemoteWebAgent)((WebApplication)proxy).getAgent();
                if (remoteWebAgent == null) {
                    return;
                }
                if (!remoteWebAgent.isReportsFolderEnabled()) {
                    return;
                }
                Object reportsFolder = remoteWebAgent.getReportsFolder();
                RemoteWebDriver driver = (RemoteWebDriver)remoteWebAgent.getDriver();
                if (!driver.getCapabilities().getBrowserName().equalsIgnoreCase("chrome")) {
                    return;
                }
                LogEntries browser = driver.manage().logs().get("browser");
                LogEntries network = driver.manage().logs().get("performance");
                try {
                    reportsFolder = (String)reportsFolder + File.separator + Objects.requireNonNull(extensionContext.getTestClass().orElse(null)).getName() + "#" + Objects.requireNonNull(extensionContext.getTestMethod().orElse(null)).getName();
                    Path pathToNetworkLogFile = Paths.get((String)reportsFolder + File.separator + System.currentTimeMillis() + "_network.log", new String[0]);
                    Path pathToConsoleLogFile = Paths.get((String)reportsFolder + File.separator + System.currentTimeMillis() + "_console.log", new String[0]);
                    Files.createDirectories(pathToNetworkLogFile.getParent(), new FileAttribute[0]);
                    Files.createFile(pathToNetworkLogFile, new FileAttribute[0]);
                    Files.createFile(pathToConsoleLogFile, new FileAttribute[0]);
                    Path writeNetworkLogFile = Files.write(pathToNetworkLogFile, String.join((CharSequence)"\n", network.getAll().stream().map(LogEntry::toString).collect(Collectors.joining(System.lineSeparator()))).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    Path writeConsoleLogFile = Files.write(pathToConsoleLogFile, String.join((CharSequence)"\n", browser.getAll().stream().map(LogEntry::toString).collect(Collectors.joining(System.lineSeparator()))).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    this.logger.log(LogLevel.INFO, "Console logs saved to file {}", new File(writeConsoleLogFile.toUri()).getAbsolutePath());
                    this.logger.log(LogLevel.INFO, "Network requests logs saved to file {}", new File(writeNetworkLogFile.toUri()).getAbsolutePath());
                }
                catch (Throwable throwable) {
                    this.logger.log(LogLevel.WARN, "Failed to get logs for console and network requests. Reason: {}", throwable.getMessage());
                }
            }
        }
    }

    private List<File> logOrSaveScreenshotAndPageSource(ExtensionContext extensionContext) {
        ArrayList<File> screenshots = new ArrayList<File>();
        boolean screenshotExists = false;
        ArrayList listOfTestProxies = (ArrayList)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"dev.pumpo5.testProxiesKeyForLocalStore");
        if (listOfTestProxies != null) {
            for (Object proxy : listOfTestProxies) {
                Object reportsFolder = null;
                TakesScreenshot driver = null;
                String type = "";
                if (proxy instanceof WebApplication) {
                    RemoteWebAgent remoteWebAgent = (RemoteWebAgent)((WebApplication)proxy).getAgent();
                    if (remoteWebAgent == null || !remoteWebAgent.isReportsFolderEnabled()) continue;
                    reportsFolder = remoteWebAgent.getReportsFolder();
                    driver = (TakesScreenshot)remoteWebAgent.getDriver();
                    type = "web";
                }
                if (proxy instanceof MobileApplication) {
                    RemoteMobileAgent remoteMobileAgent = (RemoteMobileAgent)((MobileApplication)proxy).getAgent();
                    if (remoteMobileAgent == null || !remoteMobileAgent.isReportsFolderEnabled()) continue;
                    reportsFolder = remoteMobileAgent.getReportsFolder();
                    driver = remoteMobileAgent.getDriver();
                    type = "mobile";
                }
                if (proxy instanceof WindowsApplication) {
                    WindowsAgent windowsAgent = ((WindowsApplication)proxy).getAgent();
                    if (windowsAgent == null) continue;
                    reportsFolder = "target/reports";
                    driver = windowsAgent.getDriver();
                    type = "windows";
                }
                if (reportsFolder != null) {
                    String screenshotFileName = null;
                    String sourceCodeFilename = null;
                    File reportsFolderFile = new File((String)reportsFolder);
                    if (reportsFolderFile.listFiles() != null) {
                        List<File> files = Arrays.asList(Objects.requireNonNull(reportsFolderFile.listFiles()));
                        screenshotFileName = files.stream().filter(p -> !p.isDirectory()).map(p -> p.getAbsolutePath().toLowerCase()).filter(f -> f.endsWith("png")).findFirst().orElse(null);
                        sourceCodeFilename = files.stream().filter(p -> !p.isDirectory()).map(p -> p.getAbsolutePath().toLowerCase()).filter(f -> f.endsWith("html")).findFirst().orElse(null);
                    }
                    try {
                        reportsFolder = (String)reportsFolder + File.separator + Objects.requireNonNull(extensionContext.getTestClass().orElse(null)).getName() + "#" + Objects.requireNonNull(extensionContext.getTestMethod().orElse(null)).getName();
                        Files.createDirectories(Paths.get((String)reportsFolder, new String[0]), new FileAttribute[0]);
                        if (screenshotFileName != null) {
                            String newScreenshotFileLocation = (String)reportsFolder + File.separator + Paths.get(screenshotFileName, new String[0]).getFileName();
                            Files.move(Paths.get(screenshotFileName, new String[0]), Path.of(newScreenshotFileLocation, new String[0]), new CopyOption[0]);
                            File screenshotFile = new File(newScreenshotFileLocation);
                            screenshots.add(screenshotFile);
                            this.logger.log(LogLevel.INFO, "Screenshot automatically taken by Selenide and saved to file {}", screenshotFile.getAbsolutePath());
                            screenshotExists = true;
                        }
                        if (sourceCodeFilename != null) {
                            String newSourceFileLocation = (String)reportsFolder + File.separator + Paths.get(sourceCodeFilename, new String[0]).getFileName();
                            Files.move(Paths.get(sourceCodeFilename, new String[0]), Path.of(newSourceFileLocation, new String[0]), new CopyOption[0]);
                            this.logger.log(LogLevel.INFO, "Source code file automatically created by Selenide and saved to file {}", new File(newSourceFileLocation).getAbsolutePath());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (screenshotExists) continue;
                screenshots.addAll(this.analyzeErrorAndTakeScreenshot((String)reportsFolder, driver, type));
            }
        }
        return screenshots;
    }

    private List<File> analyzeErrorAndTakeScreenshot(String reportsFolder, TakesScreenshot driver, String type) {
        if (reportsFolder != null && driver != null && !StringUtils.isEmpty((CharSequence)type)) {
            try {
                byte[] file = (byte[])driver.getScreenshotAs(OutputType.BYTES);
                String fileName = System.currentTimeMillis() + "_" + type + ".png";
                Path pathToFile = Paths.get(reportsFolder + File.separator + fileName, new String[0]);
                Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
                Files.createFile(pathToFile, new FileAttribute[0]);
                Files.write(pathToFile, file, new OpenOption[0]);
                File screenshotFile = pathToFile.toFile();
                this.logger.log(LogLevel.INFO, "Screenshot manually taken and saved to file {}", screenshotFile.getAbsolutePath());
                return List.of(screenshotFile);
            }
            catch (Throwable throwable) {
                this.logger.log(LogLevel.WARN, "Failed to take screenshot. Reason: {}", throwable.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private void stopRecordingVideo(ExtensionContext extensionContext) {
        Config config = ConfigHelper.getConfig(extensionContext);
        if (config.getBoolean("pn5.video.enabled")) {
            ArrayList listOfTestProxies = (ArrayList)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"dev.pumpo5.testProxiesKeyForLocalStore");
            for (Object proxy : listOfTestProxies) {
                if (proxy instanceof MobileApplication) {
                    RemoteMobileAgent remoteMobileAgent = (RemoteMobileAgent)((MobileApplication)proxy).getAgent();
                    AppiumDriver driver = remoteMobileAgent.getDriver();
                    RecordVideoClient.stopVideo((WebDriver)driver);
                    continue;
                }
                this.logger.log(LogLevel.INFO, "Stop recording and saving video for this platform is not supported (Only supported platform are IOS and ANDROID).", new Object[0]);
            }
        } else {
            this.logger.log(LogLevel.DEBUG, "Video recording disabled 'pn5.video.enabled = false'", new Object[0]);
        }
    }

    private void closeMobileDriver(ExtensionContext extensionContext) {
        ArrayList listOfTestProxies = (ArrayList)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"dev.pumpo5.testProxiesKeyForLocalStore");
        if (listOfTestProxies != null) {
            for (Object proxy : listOfTestProxies) {
                RemoteMobileAgent remoteMobileAgent;
                AppiumDriver driver;
                Capabilities capabilities;
                if (!(proxy instanceof MobileApplication) || (capabilities = Objects.requireNonNull((driver = (remoteMobileAgent = (RemoteMobileAgent)((MobileApplication)proxy).getAgent()).getDriver()).getCapabilities())).is("pn5:keepSession")) continue;
                driver.quit();
            }
        }
    }

    private void getDefaultContextPageSource(ExtensionContext extensionContext) {
        try {
            ArrayList listOfTestProxies = (ArrayList)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"dev.pumpo5.testProxiesKeyForLocalStore");
            if (listOfTestProxies != null) {
                for (Object proxy : listOfTestProxies) {
                    RemoteWebAgent remoteWebAgent;
                    if (!(proxy instanceof WebApplication) || (remoteWebAgent = (RemoteWebAgent)((WebApplication)proxy).getAgent()) == null) continue;
                    if (!remoteWebAgent.isReportsFolderEnabled()) {
                        return;
                    }
                    Object reportsFolder = remoteWebAgent.getReportsFolder();
                    if (((String)reportsFolder).isEmpty()) {
                        reportsFolder = "target/reports";
                    }
                    reportsFolder = (String)reportsFolder + File.separator + Objects.requireNonNull(extensionContext.getTestClass().orElse(null)).getName() + "#" + Objects.requireNonNull(extensionContext.getTestMethod().orElse(null)).getName();
                    WebDriver driver = remoteWebAgent.getDriver();
                    driver.switchTo().defaultContent();
                    String defaultContextPageSource = driver.getPageSource();
                    String fileName = System.currentTimeMillis() + "_defaultContext_pageSource.html";
                    String filePath = (String)reportsFolder + File.separator + fileName;
                    Path pathToFile = Paths.get(filePath, new String[0]);
                    Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
                    Files.createFile(pathToFile, new FileAttribute[0]);
                    Files.writeString(pathToFile, (CharSequence)defaultContextPageSource, new OpenOption[0]);
                    this.logger.log(LogLevel.INFO, "Default context page source manually saved to file {}", new File(filePath).getAbsolutePath());
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.log(LogLevel.WARN, "Failed to save page source in default context. Reason: {}", throwable.getMessage());
        }
    }
}

