/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.selenide;

import com.codeborne.selenide.SelenideConfig;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.logevents.SelenideLogger;
import dev.pumpo5.PumpoException;
import dev.pumpo5.config.Config;
import dev.pumpo5.core.Lookup;
import dev.pumpo5.core.webdriver.AppiumAgent;
import dev.pumpo5.selenide.SelenideAgent;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelenideAgent
extends AppiumAgent
implements SelenideAgent {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSelenideAgent.class);
    private static final String DEFAULT_REPORTS_FOLDER = "target/reports";
    protected final SelenideDriver selenideDriver;
    protected final Deque<Optional<WebDriver>> contexts = new ConcurrentLinkedDeque<Optional<WebDriver>>();

    protected AbstractSelenideAgent(SelenideDriver selenideDriver) {
        this.selenideDriver = selenideDriver;
    }

    protected AbstractSelenideAgent(Map<String, Object> capabilities, String farmUrl, Config config) {
        SelenideConfig selenideConfig = this.getSelenideConfig(capabilities);
        this.selenideDriver = new SelenideDriver((com.codeborne.selenide.Config)selenideConfig, (WebDriver)this.initDriver(capabilities, farmUrl, config), null);
    }

    protected abstract RemoteWebDriver initDriver(Map<String, Object> var1, String var2, Config var3);

    public abstract SelenideElement getElement(String var1, Lookup var2, int var3);

    @Override
    public void wait(String selector, Lookup type, int timeout) {
        this.runWithSelenideLog("pn5 selector: " + this.translateLookup(type).apply(selector), String.format("wait [%d s.]", timeout), sd -> super.find(selector, type, timeout));
    }

    @Override
    public Dimension getSize(String selector, Lookup type) {
        return this.getWithSelenideLog("pn5 selector: " + this.translateLookup(type).apply(selector), String.format("getSize [%d s.]", 10), sd -> super.find(selector, type, 10).getSize());
    }

    @Override
    public Optional<WebElement> tryToFind(SearchContext context, String selector, Lookup type, Duration timeout) {
        return this.getWithSelenideLog("pn5 selector: " + this.translateLookup(type).apply(selector), String.format("tryToFind [%d s.]", timeout.toSeconds()), sd -> super.tryToFind(context, selector, type, timeout));
    }

    protected void runWithSelenideLog(String source, String subject, Consumer<SelenideDriver> action) {
        SelenideLogger.run((String)source, (String)subject, () -> action.accept(this.selenideDriver));
    }

    protected <T> T getWithSelenideLog(String source, String subject, Function<SelenideDriver, T> action) {
        return (T)SelenideLogger.get((String)source, (String)subject, () -> this.usingSelenideDoAndReturn(action));
    }

    @Override
    public <T> T usingSelenideDoAndReturn(Function<SelenideDriver, T> action) {
        this.enterSelenideContext();
        try {
            T t = action.apply(this.getSelenideDriver());
            return t;
        }
        finally {
            this.exitSelenideContext();
        }
    }

    @Override
    public void usingSelenideDo(Consumer<SelenideDriver> action) {
        this.usingSelenideDoAndReturn(sd -> {
            action.accept((SelenideDriver)sd);
            return null;
        });
    }

    @Override
    public void enterSelenideContext() {
        if (WebDriverRunner.hasWebDriverStarted()) {
            this.contexts.push(Optional.of(WebDriverRunner.getWebDriver()));
        } else {
            this.contexts.push(Optional.empty());
        }
        WebDriverRunner.setWebDriver((WebDriver)this.getSelenideDriver().getWebDriver());
    }

    @Override
    public void exitSelenideContext() {
        if (!this.contexts.isEmpty()) {
            Optional<WebDriver> maybeWebDriver = this.contexts.pop();
            if (maybeWebDriver.isPresent()) {
                WebDriverRunner.setWebDriver((WebDriver)maybeWebDriver.get());
            } else {
                WebDriverRunner.webdriverContainer.resetWebDriver();
            }
        } else {
            LOG.warn("Calling exitSelenideContext(), but context stack is empty. Please make sure you use try {...} finally {...} with selenide context");
        }
    }

    @Override
    public SelenideDriver getSelenideDriver() {
        return this.selenideDriver;
    }

    @Override
    public void scrollIntoView(String selector, Lookup type, int timeout) {
        SelenideElement element = this.getElement(selector, type, timeout);
        element.scrollIntoView(true);
    }

    @Override
    public void doubleClick(String selector, Lookup type, int timeout, boolean tryCoordinates) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout * 1000L;
        SelenideElement element = this.getElement(selector, type, timeout);
        this.tryDoubleClickUntilTimeout(element, endTime, tryCoordinates);
    }

    private void tryDoubleClickUntilTimeout(SelenideElement element, long endTime, boolean tryCoordinates) {
        while (true) {
            try {
                element.doubleClick();
                break;
            }
            catch (InvalidStateException | InvalidElementStateException e) {
                if (endTime > System.currentTimeMillis()) {
                    if (tryCoordinates) {
                        Actions actions = new Actions(this.selenideDriver.getWebDriver());
                        actions.moveToElement((WebElement)element, element.getRect().width / 2, element.getRect().height / 2).doubleClick();
                        break;
                    }
                    throw e;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new PumpoException("Error trying to double click on element:", e1);
                }
            }
        }
    }

    @Override
    public void click(String selector, Lookup type, int timeout, boolean tryCoordinates) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout * 1000L;
        SelenideElement element = this.getElement(selector, type, timeout);
        this.tryClickUntilTimeout(element, endTime, tryCoordinates);
    }

    private void tryClickUntilTimeout(SelenideElement element, long endTime, boolean tryCoordinates) {
        while (true) {
            try {
                element.click();
                break;
            }
            catch (InvalidStateException | InvalidElementStateException e) {
                if (endTime > System.currentTimeMillis()) {
                    if (tryCoordinates) {
                        Actions actions = new Actions(this.selenideDriver.getWebDriver());
                        actions.moveToElement((WebElement)element, element.getRect().width / 2, element.getRect().height / 2).click();
                        break;
                    }
                    throw e;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new PumpoException("Error trying to click on element:", e1);
                }
            }
        }
    }

    @Override
    public File clickAndDownload(String selector, Lookup type, int timeout) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout * 1000L;
        SelenideElement element = this.getElement(selector, type, timeout);
        return this.tryClickAndDownloadUntilTimeout(element, endTime);
    }

    private File tryClickAndDownloadUntilTimeout(SelenideElement element, long endTime) {
        while (true) {
            try {
                File file;
                try {
                    file = element.download();
                }
                catch (FileNotFoundException e) {
                    throw new PumpoException("No file was found to be downloaded while clicking on element: " + ExceptionUtils.getStackTrace((Throwable)e));
                }
                return file;
            }
            catch (InvalidStateException | InvalidElementStateException e) {
                if (endTime > System.currentTimeMillis()) {
                    throw e;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new PumpoException("Error trying to click on element:", e1);
                }
            }
        }
    }

    @Override
    public void sendKeys(String selector, Lookup type, String keysToSend, int timeout) {
        this.getElement(selector, type, timeout).sendKeys(new CharSequence[]{keysToSend});
    }

    private SelenideConfig getSelenideConfig(Map<String, Object> capabilities) {
        SelenideConfig selenideConfig = new SelenideConfig();
        if (Boolean.TRUE.equals(capabilities.getOrDefault("pn5:selenide:reportsFolderEnabled", Boolean.TRUE))) {
            String reportsFolder = (String)capabilities.getOrDefault("pn5:selenide:reportsFolder", DEFAULT_REPORTS_FOLDER);
            selenideConfig.reportsFolder(reportsFolder);
        } else {
            selenideConfig.screenshots(false);
            selenideConfig.savePageSource(false);
        }
        return selenideConfig;
    }
}

