/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.web;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.web.WebAgent;
import dev.pumpo5.web.WebAgentAccessor;
import dev.pumpo5.web.WebDriverAccessor;
import dev.pumpo5.web.WebProxyFactory;
import dev.pumpo5.web.WebSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageProxyInvocationHandler
extends PumpoProxy {
    protected static final Logger LOG = LoggerFactory.getLogger(PageProxyInvocationHandler.class);
    private final WebProxyFactory factory;
    private final WebAgent agent;

    public PageProxyInvocationHandler(WebProxyFactory factory, CoreAccessor core, WebAgent agent) {
        super(factory, core);
        this.factory = factory;
        this.agent = agent;
    }

    @Override
    protected Optional<Object> processAdditionalDelegates(CoreAccessor core, Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (WebAgentAccessor.class.equals(method.getDeclaringClass())) {
            return Optional.of(method.invoke((Object)new WebSupport(this.agent), args));
        }
        if (WebDriverAccessor.class.equals(method.getDeclaringClass())) {
            LOG.warn("WebDriverAccessor is deprecated and will be removed. Please fix your page object {} by extending WebAgentAccessor", (Object)method.getClass().getSimpleName());
            return Optional.of(method.invoke((Object)new WebSupport(this.agent), args));
        }
        return Optional.empty();
    }

    @Override
    protected Integer processSwitchAnnotation(Method method, Object[] args) {
        return this.factory.doSwitch(method, args);
    }

    @Override
    protected File processClickAndDownloadAnnotation(Method method, Object[] args) {
        return this.factory.doClickAndDownload(method, args);
    }

    @Override
    protected void processFocusChangingAnnotations(Method method, Object[] args) {
        this.factory.doScrollIntoView(method, args);
        this.factory.doSwitchToIframe(method, args);
        this.factory.doClick(method, args);
        this.factory.doDoubleClick(method, args);
        this.factory.doSelect(method, args);
        this.factory.doMaximizeWindow(method);
        this.factory.doRefreshPage(method);
    }
}

