/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.web;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import dev.pumpo5.PumpoException;
import dev.pumpo5.Utils;
import dev.pumpo5.config.Config;
import dev.pumpo5.core.Lookup;
import dev.pumpo5.selenide.AbstractSelenideAgent;
import dev.pumpo5.web.WebAgent;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Keys;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWebAgent
extends AbstractSelenideAgent
implements WebAgent {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteWebAgent.class);

    RemoteWebAgent(SelenideDriver selenideDriver) {
        super(selenideDriver);
    }

    public RemoteWebAgent(Map<String, Object> capabilities, String farmUrl, Config config) {
        super(capabilities, farmUrl, config);
    }

    @Override
    protected RemoteWebDriver initDriver(Map<String, Object> capabilities, String farmUrl, Config config) {
        MutableCapabilities mutableCapabilities = new MutableCapabilities(capabilities);
        this.addLoggingPreferences(mutableCapabilities);
        try {
            RemoteWebDriver driver = new RemoteWebDriver(URI.create(farmUrl).toURL(), (Capabilities)mutableCapabilities, false);
            driver.setFileDetector((FileDetector)new LocalFileDetector());
            return driver;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot create Remote Web Driver", e);
        }
    }

    private void addLoggingPreferences(MutableCapabilities capabilities) {
        if (capabilities.getCapability("browserName").equals("chrome") && capabilities.getCapability("goog:loggingPrefs") == null) {
            LoggingPreferences logPrefs = new LoggingPreferences();
            logPrefs.enable("performance", Level.ALL);
            logPrefs.enable("browser", Level.ALL);
            capabilities.setCapability("goog:loggingPrefs", (Object)logPrefs);
        }
    }

    @Override
    public void maximizeWindow() {
        this.runWithSelenideLog("pn5 action", "maximizeWindow", driver -> driver.getWebDriver().manage().window().maximize());
    }

    @Override
    public void sendKeys(String selector, Lookup type, String keysToSend, int timeout) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (!element.equals(this.selenideDriver.switchTo().activeElement())) {
            LOG.warn("The input is not in focus. When using @SendKeys annotation, make sure to focus on the input field first. The agent will first click on the element now.");
            element.click();
        }
        element.sendKeys(new CharSequence[]{keysToSend});
    }

    @Override
    public void refreshPage() {
        this.getDriver().navigate().refresh();
    }

    @Override
    public String getUrl() {
        return this.getDriver().getCurrentUrl();
    }

    @Override
    public String getText(String selector, Lookup type, int timeout) {
        return this.getElement(selector, type, timeout).getText();
    }

    @Override
    public String getAttribute(String selector, Lookup type, String attributeName, int timeout) {
        String returnValue = this.getElement(selector, type, timeout).getAttribute(attributeName);
        return returnValue == null ? "" : returnValue;
    }

    @Override
    public void setValue(String selector, Lookup type, String value, int timeout, boolean byTyping) {
        SelenideElement element = this.getElement(selector, type, timeout);
        element.scrollIntoView(true);
        if (!byTyping) {
            element.setValue(value);
        } else {
            try {
                element.clear();
                TimeUnit.MILLISECONDS.sleep(200L);
                element.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                element.sendKeys(new CharSequence[]{Keys.DELETE});
                TimeUnit.MILLISECONDS.sleep(200L);
                element.setValue("");
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException ex) {
                throw new PumpoException("Error trying to set value on element:", ex);
            }
            element.sendKeys(new CharSequence[]{value});
        }
    }

    @Override
    public void selectOption(String selector, Lookup type, int timeout, int ... indexes) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (indexes.length == 1) {
            element.selectOption(indexes[0], new int[0]);
        } else {
            element.selectOption(indexes[0], Arrays.copyOfRange(indexes, 1, indexes.length));
        }
    }

    @Override
    public void selectOption(String selector, Lookup type, int timeout, String ... texts) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (texts.length == 1) {
            element.selectOption(texts[0], new String[0]);
        } else {
            element.selectOption(texts[0], Arrays.copyOfRange(texts, 1, texts.length));
        }
    }

    @Override
    public void selectOptionByValue(String selector, Lookup type, int timeout, String ... values) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (values.length == 1) {
            element.selectOption(values[0], new String[0]);
        } else {
            element.selectOptionByValue(values[0], Arrays.copyOfRange(values, 1, values.length));
        }
    }

    @Override
    public void open(String relativeOrAbsoluteUrl) {
        this.selenideDriver.open(relativeOrAbsoluteUrl);
    }

    @Override
    public void switchToIframe(String selector, Lookup type, int timeout) {
        SelenideElement element = this.getElement(selector, type, timeout);
        this.selenideDriver.switchTo().frame((WebElement)element);
    }

    @Override
    public void switchToDefaultContent() {
        this.selenideDriver.switchTo().defaultContent();
    }

    @Override
    public WebDriver getDriver() {
        return this.selenideDriver.getWebDriver();
    }

    @Override
    public SelenideElement getElement(String selector, Lookup type, int timeout) {
        try {
            return this.selenideDriver.$(this.translateLookup(type).apply(selector)).shouldBe(Condition.visible, Duration.ofSeconds(timeout));
        }
        catch (ElementNotFound e) {
            throw new NoSuchElementException(e.getMessage(), (Throwable)e);
        }
    }

    public String getReportsFolder() {
        return this.selenideDriver.config().reportsFolder();
    }

    public boolean isReportsFolderEnabled() {
        return this.selenideDriver.config().screenshots() && this.selenideDriver.config().savePageSource();
    }

    @Override
    public Function<String, By> translateLookup(Lookup lookup) {
        lookup = Utils.getDefaultLookupValue(((RemoteWebDriver)this.selenideDriver.getWebDriver()).getCapabilities(), lookup);
        switch (lookup) {
            case NAME: {
                return By::name;
            }
            case XPATH: {
                return By::xpath;
            }
            case CLASS_NAME: {
                return By::className;
            }
            case ID: 
            case DEFAULT: {
                return By::id;
            }
        }
        throw new UnsupportedOperationException(String.format("We do not support Lookup '%s' for web applications", lookup.name()));
    }
}

