/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.web;

import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.util.ExtensionUtils;
import dev.pumpo5.core.webdriver.WebDriverClientExtension;
import dev.pumpo5.web.Browser;
import dev.pumpo5.web.WebApplication;
import dev.pumpo5.web.WebApplicationSupport;
import dev.pumpo5.web.WebApplicationTestTemplateInvocationContext;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

public class WebApplicationExtension
extends WebDriverClientExtension<WebApplication>
implements TestTemplateInvocationContextProvider {
    public WebApplicationExtension() {
        super(WebApplication.class);
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Optional.of(parameterContext).map(ParameterContext::getParameter).filter(p -> ArrayUtils.getLength((Object)p.getAnnotationsByType(Browser.class)) <= 1).map(Parameter::getType).filter(WebApplication.class::isAssignableFrom).isPresent();
    }

    @Override
    protected WebApplication createProxy(Class<? extends WebApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        return WebApplicationSupport.createProxy(type, driverUrl, capabilities, core);
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        long count = Arrays.stream(context.getRequiredTestMethod().getParameters()).filter(p -> WebApplication.class.isAssignableFrom(p.getType())).filter(p -> ArrayUtils.getLength((Object)p.getAnnotationsByType(Browser.class)) > 1).count();
        if (count > 1L) {
            throw new IllegalArgumentException("You can use @Browser annotation only once per ParametrizedTest");
        }
        return count == 1L;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Config config = ConfigHelper.getConfig(context);
        Stream<TestTemplateInvocationContext> contexts = Arrays.stream(context.getRequiredTestMethod().getParameters()).filter(p -> WebApplication.class.isAssignableFrom(p.getType())).filter(p -> ArrayUtils.getLength((Object)p.getAnnotationsByType(Browser.class)) > 1).flatMap(p -> this.getDeviceDescriptors((Parameter)p, config)).map(t -> new WebApplicationTestTemplateInvocationContext((String)t.getLeft(), (String)t.getMiddle(), (Map)t.getRight(), context.getRequiredTestMethod()));
        Iterator iterator = contexts.iterator();
        if (iterator.hasNext()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        throw new IllegalArgumentException("You have to provide at least one valid device ");
    }

    private Stream<Triple<String, String, Map<String, Object>>> getDeviceDescriptors(Parameter parameter, Config config) {
        return ExtensionUtils.getDeviceDescriptors(parameter, Browser.class, Browser::description, Browser::capabilities, Browser::inheritCapabilities, config);
    }
}

