/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.web;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.web.RemoteWebAgent;
import dev.pumpo5.web.WebAgent;
import dev.pumpo5.web.WebAgentAccessor;
import dev.pumpo5.web.WebApplication;
import dev.pumpo5.web.WebProxyFactory;
import dev.pumpo5.web.actions.Navigate;
import java.lang.reflect.Proxy;
import java.util.Map;

public class WebApplicationSupport
extends ApplicationSupport<WebApplication>
implements WebApplication,
WebAgentAccessor {
    private WebProxyFactory factory;
    private WebAgent agent;

    public static <APPLICATION_OBJECT extends WebApplication> APPLICATION_OBJECT createProxy(Class<?> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("proxy type must be an interface but was %s", type.getSimpleName()));
        }
        if (!WebApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("proxy type must extend WebApplication");
        }
        return (APPLICATION_OBJECT)((WebApplication)Proxy.newProxyInstance(WebApplicationSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<WebApplicationSupport>(type, new WebApplicationSupport(core, driverUrl, capabilities))));
    }

    private WebApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
        this.factory = new WebProxyFactory(this.agent, this.core);
    }

    @Override
    public RemoteWebAgent newAgent() {
        return new RemoteWebAgent(this.capabilities, this.driverUrl, this.core.getConfig());
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
            this.factory = null;
        }
    }

    @Override
    public <PAGE_OBJECT> PAGE_OBJECT open(Class<PAGE_OBJECT> page) {
        this.checkSessionStarted();
        if (page.isInterface()) {
            return this.factory.prepareProxy(page, true, this.core);
        }
        Navigate[] navigateAnnotations = (Navigate[])page.getAnnotationsByType(Navigate.class);
        if (navigateAnnotations.length >= 1) {
            Navigate navigateAnnotation = navigateAnnotations[0];
            String url = this.getConfig().getOrDefault((Object)navigateAnnotation.value(), navigateAnnotation.value());
            this.agent.usingSelenideDo(selenideDriver -> this.agent.open(url));
        }
        return this.factory.prepareClassProxy(page);
    }

    @Override
    public WebAgent getAgent() {
        return this.agent;
    }
}

