/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.web;

import dev.pumpo5.PumpoException;
import dev.pumpo5.actions.Click;
import dev.pumpo5.actions.ClickAndDownload;
import dev.pumpo5.actions.DoubleClick;
import dev.pumpo5.actions.MaximizeWindow;
import dev.pumpo5.actions.RefreshPage;
import dev.pumpo5.actions.ScrollIntoView;
import dev.pumpo5.actions.Switch;
import dev.pumpo5.config.Config;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.State;
import dev.pumpo5.core.util.TestUtils;
import dev.pumpo5.core.webdriver.ProxyFactory;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.web.PageProxyInvocationHandler;
import dev.pumpo5.web.WebAgent;
import dev.pumpo5.web.actions.Navigate;
import dev.pumpo5.web.actions.Select;
import dev.pumpo5.web.actions.SwitchToIframe;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ClassUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriverException;

public final class WebProxyFactory
extends ProxyFactory {
    private final WebAgent agent;

    public WebProxyFactory(WebAgent agent, CoreAccessor core) {
        super(agent, core);
        this.agent = agent;
    }

    @Override
    public void enterInvocation() {
        this.agent.enterSelenideContext();
    }

    @Override
    public void exitInvocation() {
        this.agent.exitSelenideContext();
    }

    @Override
    protected PumpoProxy getInvocationHandler() {
        return new PageProxyInvocationHandler(this, this.core, this.agent);
    }

    @Override
    protected void processPageObjectAnnotations(Class<?> pageObject, boolean navigate, CoreAccessor core) {
        List interfaces = ClassUtils.getAllInterfaces(pageObject);
        interfaces.add(0, pageObject);
        if (navigate) {
            Class anInterface;
            boolean navigateWasApplied;
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext() && !(navigateWasApplied = this.doNavigate(anInterface = (Class)iterator.next(), core.getConfig()))) {
            }
        }
        Collections.reverse(interfaces);
        interfaces.forEach(x$0 -> this.doWait((AnnotatedElement)x$0));
        interfaces.forEach(x$0 -> this.doAssertUrl((AnnotatedElement)x$0));
    }

    void doSwitchToIframe(Method method, Object[] args) {
        SwitchToIframe annotation = method.getAnnotation(SwitchToIframe.class);
        if (annotation != null) {
            if (annotation.value().isEmpty()) {
                LOG.debug("{} > @SwitchToIframe with empty value -> switch back to default content");
                this.agent.switchToDefaultContent();
                return;
            }
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @SwitchToIframe for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            try {
                this.agent.switchToIframe(finalSelector, annotation.by(), annotation.timeout());
            }
            catch (WebDriverException e) {
                LOG.debug("{} > @SwitchToIframe failed with exception thrown {} ({})", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName()});
                throw e;
            }
        }
    }

    boolean doNavigate(AnnotatedElement pageObject, Config config) {
        Navigate[] navigateAnnotations = (Navigate[])pageObject.getAnnotationsByType(Navigate.class);
        if (navigateAnnotations.length > 1) {
            throw new IllegalArgumentException("@Navigate annotation does not make sense to be present multiple times");
        }
        if (navigateAnnotations.length == 1) {
            Navigate navigateAnnotation = navigateAnnotations[0];
            String url = config.getOrDefault((Object)navigateAnnotation.value(), navigateAnnotation.value());
            LOG.debug("{} > @Navigate to {}", (Object)this.getAnnotatedElementShortName(pageObject), (Object)url);
            this.agent.open(url);
            return true;
        }
        return false;
    }

    void doSelect(Method method, Object[] args) {
        Select annotation = method.getAnnotation(Select.class);
        if (annotation != null) {
            if (args == null) {
                throw new IllegalArgumentException("@Select requires at least one parameter (which should specify either option name or option index)");
            }
            Object untypedArgument = args[args.length - 1];
            String finalSelector = this.processSelector(annotation.value(), args, 1, annotation);
            if (untypedArgument instanceof Integer) {
                Integer optionIndex = (Integer)untypedArgument;
                LOG.debug("{} > @Select for {} by {} for option at index {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), optionIndex});
                this.agent.selectOption(finalSelector, annotation.by(), annotation.timeout(), optionIndex);
            } else {
                String textOrValue = String.valueOf(untypedArgument);
                if (annotation.byText()) {
                    LOG.debug("{} > @Select for {} by {} for option with text {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), textOrValue});
                    this.agent.selectOption(finalSelector, annotation.by(), annotation.timeout(), textOrValue);
                } else {
                    LOG.debug("{} > @Select for {} by {} for option with value {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), textOrValue});
                    this.agent.selectOptionByValue(finalSelector, annotation.by(), annotation.timeout(), textOrValue);
                }
            }
        }
    }

    Integer doSwitch(Method method, Object[] args) {
        Switch[] switchAnnotations = (Switch[])method.getAnnotationsByType(Switch.class);
        if (switchAnnotations.length > 0) {
            int longestTimeout = 0;
            for (Switch aSwitch : switchAnnotations) {
                String finalSelector = this.processSelector(aSwitch.value(), args, 0, aSwitch);
                LOG.debug("{} > @Switch returning {} if {} by {} is {} {} {}s", new Object[]{this.getAnnotatedElementShortName(method), aSwitch.returnOption(), finalSelector, aSwitch.by(), aSwitch.state(), aSwitch.state() == State.VISIBLE ? "anytime before" : "just after", aSwitch.timeout()});
                longestTimeout = Math.max(longestTimeout, aSwitch.timeout());
            }
            long initialTime = System.currentTimeMillis();
            long deadline = initialTime + (long)longestTimeout * 1000L;
            while (true) {
                long iterationStartTime = System.currentTimeMillis();
                for (Switch aSwitch : switchAnnotations) {
                    String finalSelector = this.processSelector(aSwitch.value(), args, 0, aSwitch);
                    State state = aSwitch.state();
                    if (state == State.VISIBLE && iterationStartTime < initialTime + (long)aSwitch.timeout() * 1000L) {
                        try {
                            this.agent.find(finalSelector, aSwitch.by(), 0);
                            return this.returnOptionLogged(method, aSwitch);
                        }
                        catch (NoSuchElementException | NoSuchWindowException throwable) {
                            continue;
                        }
                    }
                    if (state != State.ABSENT || iterationStartTime < initialTime + (long)aSwitch.timeout() * 1000L) continue;
                    try {
                        this.agent.find(finalSelector, aSwitch.by(), 0);
                    }
                    catch (NoSuchElementException | NoSuchWindowException noMoreThere) {
                        return this.returnOptionLogged(method, aSwitch);
                    }
                }
                if (iterationStartTime > deadline) break;
                long timeToSleep = iterationStartTime + 1000L - System.currentTimeMillis();
                if (timeToSleep <= 0L) continue;
                TestUtils.threadSleep(timeToSleep);
            }
            throw new PumpoException("No switch option was validated after the longest timeout.");
        }
        return null;
    }

    private int returnOptionLogged(Method method, Switch aSwitch) {
        LOG.debug("{} > @Switch returning {}", (Object)this.getAnnotatedElementShortName(method), (Object)aSwitch.returnOption());
        return aSwitch.returnOption();
    }

    public File doClickAndDownload(Method method, Object[] args) {
        AtomicReference file = new AtomicReference();
        Arrays.stream((ClickAndDownload[])method.getAnnotationsByType(ClickAndDownload.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @ClickAndDownload for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            int retries = annotation.retries();
            Duration pause = Duration.ofSeconds(annotation.pause());
            WebDriverException lastException = null;
            while (true) {
                try {
                    file.set(this.agent.clickAndDownload(finalSelector, annotation.by(), annotation.timeout()));
                }
                catch (WebDriverException e) {
                    LOG.debug("{} > @ClickAndDownload failed with exception thrown {} ({}), retries {}, pause {}", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), retries, pause});
                    lastException = e;
                    if (--retries == 0) continue;
                    LOG.trace("{} > @ClickAndDownload waiting {}s before retrying", (Object)this.getAnnotatedElementShortName(method), (Object)pause);
                    TestUtils.threadSleep(pause.toMillis());
                    LOG.trace("{} > @ClickAndDownload now retrying", (Object)this.getAnnotatedElementShortName(method));
                    if (retries > 0) continue;
                }
                break;
            }
            if (file.get() == null) {
                LOG.warn("{} > @ClickAndDownload ran out of retries", (Object)this.getAnnotatedElementShortName(method));
                lastException.addSuppressed((Throwable)new PumpoException(String.format("Failed after %s retries", annotation.retries())));
                throw lastException;
            }
        });
        return (File)file.get();
    }

    void doClick(Method method, Object[] args) {
        Arrays.stream((Click[])method.getAnnotationsByType(Click.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @Click for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            int retries = annotation.retries();
            Duration pause = Duration.ofSeconds(annotation.pause());
            while (true) {
                try {
                    this.agent.click(finalSelector, annotation.by(), annotation.timeout(), annotation.tryCoordinates());
                    return;
                }
                catch (WebDriverException e) {
                    LOG.debug("{} > @Click failed with exception thrown {} ({}), retries {}, pause {}", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), retries, pause});
                    WebDriverException lastException = e;
                    if (--retries == 0) continue;
                    LOG.trace("{} > @Click waiting {}s before retrying", (Object)this.getAnnotatedElementShortName(method), (Object)pause);
                    TestUtils.threadSleep(pause.toMillis());
                    LOG.trace("{} > @Click now retrying", (Object)this.getAnnotatedElementShortName(method));
                    if (retries > 0) continue;
                    LOG.warn("{} > @Click ran out of retries", (Object)this.getAnnotatedElementShortName(method));
                    lastException.addSuppressed((Throwable)new PumpoException(String.format("Failed after %s retries", annotation.retries())));
                    throw lastException;
                }
                break;
            }
        });
    }

    void doDoubleClick(Method method, Object[] args) {
        Arrays.stream((DoubleClick[])method.getAnnotationsByType(DoubleClick.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @DoubleClick for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            int retries = annotation.retries();
            Duration pause = Duration.ofSeconds(annotation.pause());
            while (true) {
                try {
                    this.agent.doubleClick(finalSelector, annotation.by(), annotation.timeout(), annotation.tryCoordinates());
                    return;
                }
                catch (WebDriverException e) {
                    LOG.debug("{} > @DoubleClick failed with exception thrown {} ({}), retries {}, pause {}", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), retries, pause});
                    WebDriverException lastException = e;
                    if (--retries == 0) continue;
                    LOG.trace("{} > @DoubleClick waiting {}s before retrying", (Object)this.getAnnotatedElementShortName(method), (Object)pause);
                    TestUtils.threadSleep(pause.toMillis());
                    LOG.trace("{} > @DoubleClick now retrying", (Object)this.getAnnotatedElementShortName(method));
                    if (retries > 0) continue;
                    LOG.warn("{} > @DoubleClick ran out of retries", (Object)this.getAnnotatedElementShortName(method));
                    lastException.addSuppressed((Throwable)new PumpoException(String.format("Failed after %s retries", annotation.retries())));
                    throw lastException;
                }
                break;
            }
        });
    }

    @Override
    protected void doSendKeys(Method method, Object[] args) {
        super.doSendKeys(method, args);
    }

    void doMaximizeWindow(Method method) {
        if (method.getAnnotation(MaximizeWindow.class) != null) {
            LOG.debug("{} > @MaximizeWindow", (Object)this.getAnnotatedElementShortName(method));
            this.agent.maximizeWindow();
        }
    }

    void doRefreshPage(Method method) {
        if (method.getAnnotation(RefreshPage.class) != null) {
            LOG.debug("{} > @RefreshPage", (Object)this.getAnnotatedElementShortName(method));
            this.agent.refreshPage();
        }
    }

    void doScrollIntoView(Method method, Object[] args) {
        ScrollIntoView annotation = method.getAnnotation(ScrollIntoView.class);
        if (annotation != null) {
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @ScrollIntoView for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            this.agent.scrollIntoView(finalSelector, annotation.by(), annotation.timeout());
        }
    }
}

