/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.SessionManager;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.ocr.OcrAgent;
import dev.pumpo5.win.WindowsAgent;
import dev.pumpo5.win.WindowsAgentAccessor;
import dev.pumpo5.win.WindowsApplication;
import dev.pumpo5.win.WindowsProxyFactory;
import dev.pumpo5.win.winappdriver.WinAppDriverAgent;
import java.lang.reflect.Proxy;
import java.util.Map;

public class WindowsApplicationSupport
extends ApplicationSupport<WindowsApplication>
implements WindowsApplication,
WindowsAgentAccessor,
SessionManager<WindowsApplication> {
    private WindowsProxyFactory factory;
    private WindowsAgent agent;
    private final OcrAgent ocrAgent = null;

    public static <APPLICATION_OBJECT extends WindowsApplication> APPLICATION_OBJECT createProxy(Class<?> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("proxy type must be an interface but was %s", type.getSimpleName()));
        }
        if (!WindowsApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("proxy type must extend WindowsApplication");
        }
        return (APPLICATION_OBJECT)((WindowsApplication)Proxy.newProxyInstance(WindowsApplicationSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<WindowsApplicationSupport>(type, new WindowsApplicationSupport(core, driverUrl, capabilities))));
    }

    public WindowsApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
        this.factory = this.ocrAgent == null ? new WindowsProxyFactory(this.agent, this.core) : new WindowsProxyFactory(this.agent, this.ocrAgent, this.core);
    }

    @Override
    public WinAppDriverAgent newAgent() {
        return new WinAppDriverAgent(this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
            this.factory = null;
        }
    }

    @Override
    public <WINDOW_OBJECT> WINDOW_OBJECT find(Class<WINDOW_OBJECT> page) {
        return this.factory.prepareProxy(page, true, this.core);
    }

    @Override
    public void close() {
        this.factory.close();
    }

    @Override
    public WindowsAgent getAgent() {
        return this.agent;
    }
}

