/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win;

import dev.pumpo5.actions.Click;
import dev.pumpo5.actions.ClickImage;
import dev.pumpo5.actions.DoubleClick;
import dev.pumpo5.actions.MaximizeWindow;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.ProxyFactory;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.remote.ocr.OcrAgent;
import dev.pumpo5.remote.ocr.OcrResponse;
import dev.pumpo5.win.WindowsAgent;
import dev.pumpo5.win.WindowsProxyInvocationHandler;
import dev.pumpo5.win.actions.ClickAt;
import dev.pumpo5.win.actions.StoreClipboardContent;
import dev.pumpo5.win.coordinates.Coordinates;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;

public class WindowsProxyFactory
extends ProxyFactory {
    private final WindowsAgent agent;
    private OcrAgent ocrAgent;

    public WindowsProxyFactory(WindowsAgent agent, CoreAccessor core) {
        super(agent, core);
        this.agent = agent;
    }

    public WindowsProxyFactory(WindowsAgent agent, OcrAgent ocrAgent, CoreAccessor core) {
        super(agent, core);
        this.agent = agent;
        this.ocrAgent = ocrAgent;
    }

    @Override
    protected PumpoProxy getInvocationHandler() {
        return new WindowsProxyInvocationHandler(this, this.core, this.agent);
    }

    void doClick(Method method, Object[] args) {
        Arrays.stream((Click[])method.getAnnotationsByType(Click.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @Click for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            this.agent.click(finalSelector, annotation.by(), annotation.timeout(), annotation.tryCoordinates());
        });
    }

    void doDoubleClick(Method method, Object[] args) {
        Arrays.stream((DoubleClick[])method.getAnnotationsByType(DoubleClick.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @DoubleClick for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            this.agent.doubleClick(finalSelector, annotation.by(), annotation.timeout(), annotation.tryCoordinates());
        });
    }

    void failDoingMaximizeWindow(Method method, Object[] args) {
        if (method.getAnnotation(MaximizeWindow.class) != null) {
            throw new UnsupportedOperationException("@MaximizeWindow is not ready yet on windows");
        }
    }

    void doClickByImageLocation(Method method, Object[] args) {
        ClickImage[] clicks = (ClickImage[])method.getAnnotationsByType(ClickImage.class);
        if (clicks.length != 0 && this.ocrAgent == null) {
            throw new IllegalStateException("You cannot use this annotation without configuring OcrDriver");
        }
        Arrays.stream(clicks).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.selector(), args, 0, (Annotation)annotation);
            byte[] elementScreenshot = this.agent.takeScreenshot(finalSelector, annotation.by());
            OcrResponse ocrResponse = this.ocrAgent.findImage(elementScreenshot, this.readImage());
            OcrResponse.Coordinates coordinates = ocrResponse.buttonCenter();
            LOG.debug("{} > @ClickImage for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            this.agent.clickAt(finalSelector, annotation.by(), Coordinates.of((int)coordinates.x(), (int)coordinates.y()), annotation.timeout());
        });
    }

    private byte[] readImage() {
        return new byte[0];
    }

    void doClickAt(Method method, Object[] args) {
        Arrays.stream((ClickAt[])method.getAnnotationsByType(ClickAt.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            ClickAt.Corner corner = annotation.relativeTo();
            LOG.debug("{} > @ClickAt for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            this.agent.clickAt(finalSelector, annotation.by(), Coordinates.of(annotation.dx(), annotation.dy()), corner, annotation.timeout());
        });
    }

    @Override
    protected void doSendKeys(Method method, Object[] args) {
        super.doSendKeys(method, args);
    }

    protected void doStoreClipboardContent(Method method, Object[] args) {
        StoreClipboardContent annotation = method.getAnnotation(StoreClipboardContent.class);
        if (annotation != null) {
            if (args == null) {
                throw new IllegalArgumentException("@StoreClipboardContent requires at least one parameter");
            }
            String key = String.valueOf(args[args.length - 1]);
            LOG.debug("{} > @StoreClipboardContent to be stored at key {}", (Object)this.getAnnotatedElementShortName(method), (Object)key);
            String text = this.agent.getClipboard();
            if (annotation.globalStore()) {
                this.core.getGlobalStore().store(key, text);
            } else {
                this.core.getLocalStore().store(key, text);
            }
        }
    }

    void close() {
        this.agent.getDriver().quit();
    }
}

