/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.win.WindowsAgent;
import dev.pumpo5.win.WindowsAgentAccessor;
import dev.pumpo5.win.WindowsProxyFactory;
import dev.pumpo5.win.WindowsSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public class WindowsProxyInvocationHandler
extends PumpoProxy {
    private WindowsProxyFactory factory;
    private WindowsAgent agent;

    public WindowsProxyInvocationHandler(WindowsProxyFactory factory, CoreAccessor core, WindowsAgent agent) {
        super(factory, core);
        this.factory = factory;
        this.agent = agent;
    }

    @Override
    protected Optional<Object> processAdditionalDelegates(CoreAccessor core, Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (WindowsAgentAccessor.class.equals(method.getDeclaringClass())) {
            return Optional.of(method.invoke((Object)new WindowsSupport(this.agent), args));
        }
        return Optional.empty();
    }

    @Override
    protected void processFocusChangingAnnotations(Method method, Object[] args) {
        this.factory.failDoingMaximizeWindow(method, args);
        this.factory.doClick(method, args);
        this.factory.doDoubleClick(method, args);
        this.factory.doClickAt(method, args);
        this.factory.doClickByImageLocation(method, args);
    }

    @Override
    protected void processClipboardAnnotations(Method method, Object[] args) {
        this.factory.doStoreClipboardContent(method, args);
    }
}

