/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win.winappdriver;

import dev.pumpo5.PumpoException;
import dev.pumpo5.Utils;
import dev.pumpo5.core.Lookup;
import dev.pumpo5.core.util.FeatureMapUtils;
import dev.pumpo5.core.util.TestUtils;
import dev.pumpo5.core.webdriver.AppiumAgent;
import dev.pumpo5.win.WindowsAgent;
import dev.pumpo5.win.actions.ClickAt;
import dev.pumpo5.win.coordinates.Coordinates;
import dev.pumpo5.win.winappdriver.WinAppDriverCommandExecutor;
import dev.pumpo5.win.winappdriver.patched.WinAppWindowsDriver;
import io.appium.java_client.windows.WindowsDriver;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinAppDriverAgent
extends AppiumAgent
implements WindowsAgent {
    private static final Logger LOG = LoggerFactory.getLogger(WinAppDriverAgent.class);
    public static final String NOT_IMPLEMENTED_YET = "not implemented yet";
    private final WindowsDriver driver;
    private static final String CLIPBOARD_COMMAND = "clipboard";
    private static final String SIZE_COMMAND = "selenium3Size";
    private static final String MOVE_TO_COMMAND = "selenium3MoveTo";
    private static final String CLICK_COMMAND = "selenium3Click";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>();

    public WinAppDriverAgent(Map<String, Object> capabilities, String farmUrl) {
        this.driver = this.initDriver(capabilities, farmUrl);
    }

    protected WindowsDriver initDriver(Map<String, Object> capabilities, String farmUrl) {
        int retries = FeatureMapUtils.getInt(capabilities, "pn5:retry-session", 2);
        LOG.info("Will try to initialize WindowsDriver with {} retries", (Object)retries);
        MutableCapabilities caps = new MutableCapabilities();
        for (Map.Entry<String, Object> entry : capabilities.entrySet()) {
            caps.setCapability(entry.getKey(), entry.getValue());
        }
        while (true) {
            try {
                WinAppDriverCommandExecutor executor = new WinAppDriverCommandExecutor(this.getAdditionalCommands(), URI.create(farmUrl).toURL());
                return new WinAppWindowsDriver((HttpCommandExecutor)executor, (Capabilities)caps);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            catch (SessionNotCreatedException e) {
                if (retries <= 0) {
                    throw new IllegalStateException("Failed to initialize WindowsDriver", e);
                }
                LOG.warn("Failed to initialize WindowsDriver, attempts left: {}", (Object)(--retries));
                TestUtils.threadSleep(1000L);
                continue;
            }
            break;
        }
    }

    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    @Override
    public WindowsDriver getDriver() {
        return this.driver;
    }

    @Override
    public String getClipboard() {
        Response response = this.driver.execute(CLIPBOARD_COMMAND);
        Map responseMap = (Map)response.getValue();
        if (responseMap.get("error") != null) {
            LOG.error("Clipboard request returned error: {}", (Object)response);
            throw new PumpoException(String.format("Error while getting clipboard received from remote driver: %s", response));
        }
        return (String)responseMap.get(CLIPBOARD_COMMAND);
    }

    @Override
    public Dimension getSize(String selector, Lookup type) {
        String elementId = this.getElementId(selector, type);
        return this.getSize(elementId);
    }

    private String getElementId(String selector, Lookup type) {
        return ((RemoteWebElement)this.find(selector, type, 10)).getId();
    }

    @Override
    public void clickAt(String selector, Lookup type, Coordinates coordinates, int timeout) {
        this.clickAt(selector, type, coordinates, ClickAt.Corner.TOPLEFT, timeout);
    }

    @Override
    public void clickAt(String selector, Lookup type, Coordinates coordinates, ClickAt.Corner relativeTo, int timeout) {
        String elementId = this.getElementId(selector, type);
        Dimension size = this.getSize(elementId);
        long dx = coordinates.dx;
        long dy = coordinates.dy;
        switch (relativeTo) {
            case BOTTOMRIGHT: {
                dx += (long)size.width;
                dy += (long)size.height;
                break;
            }
            case BOTTOMLEFT: {
                dy += (long)size.height;
                break;
            }
            case TOPRIGHT: {
                dx += (long)size.width;
                break;
            }
        }
        this.moveTo(elementId, dy, dx);
        TestUtils.threadSleep(500L);
        this.click();
    }

    private Dimension getSize(String elementId) {
        Response response = this.driver.execute(SIZE_COMMAND, Map.of("elementId", elementId));
        Map responseMap = (Map)response.getValue();
        if (responseMap.get("error") != null) {
            LOG.error("Get element size request returned error: {}", (Object)response);
            throw new PumpoException(String.format("Error while getting size of element received from remote driver: %s", response));
        }
        return new Dimension(((Long)responseMap.get("width")).intValue(), ((Long)responseMap.get("height")).intValue());
    }

    private void moveTo(String elementId, Long yOffset, Long xOffset) {
        Response response = this.driver.execute(MOVE_TO_COMMAND, Map.of("element", elementId, "yoffset", yOffset, "xoffset", xOffset));
        Map responseMap = (Map)response.getValue();
        if (responseMap.get("error") != null) {
            LOG.error("MoveTo request returned error: {}", (Object)response);
            throw new PumpoException(String.format("Error while moving to coordinates received from remote driver: %s", response));
        }
    }

    private void click() {
        Response response = this.driver.execute(CLICK_COMMAND, Map.of("button", 0));
        Map responseMap = (Map)response.getValue();
        if (responseMap.get("error") != null) {
            LOG.error("Click request returned error: {}", (Object)response);
            throw new PumpoException(String.format("Error while clicking on mouse location received from remote driver: %s", response));
        }
    }

    @Override
    public void click(String selector, Lookup type, int timeout, boolean tryCoordinates) {
        this.find(selector, type, timeout).click();
    }

    @Override
    public void doubleClick(String selector, Lookup type, int timeout, boolean tryCoordinates) {
        this.click(selector, type, timeout, false);
        this.click(selector, type, timeout, false);
    }

    @Override
    public void click(SearchContext context, String selector, Lookup type, int timeout, boolean tryCoordinates) {
        this.find(context, selector, type, timeout).click();
    }

    @Override
    public void scrollIntoView(String selector, Lookup type, int timeout) {
        throw new UnsupportedOperationException("This agent does not support scrollIntoView() method");
    }

    @Override
    public void sendKeys(String selector, Lookup type, String keysToSend, int timeout) {
        this.find(selector, type, timeout).sendKeys(new CharSequence[]{keysToSend});
    }

    @Override
    public void setValue(String selector, Lookup type, String value, int timeout, boolean byTyping) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public String getText(String selector, Lookup by, int timeout) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public String getAttribute(String selector, Lookup by, String attributeName, int timeout) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public Function<String, By> translateLookup(Lookup lookup) {
        lookup = Utils.getDefaultLookupValue(this.driver.getCapabilities(), lookup);
        switch (lookup) {
            case XPATH: 
            case DEFAULT: {
                return By::xpath;
            }
        }
        throw new UnsupportedOperationException(String.format("We do not support Lookup '%s' for windows applications", lookup.name()));
    }

    @Override
    public String getUrl() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    static {
        ADDITIONAL_COMMANDS.put(CLIPBOARD_COMMAND, new CommandInfo("/session/:sessionId/clipboard", HttpMethod.GET));
        ADDITIONAL_COMMANDS.put(SIZE_COMMAND, new CommandInfo("/session/:sessionId/element/:elementId/size", HttpMethod.GET));
        ADDITIONAL_COMMANDS.put(MOVE_TO_COMMAND, new CommandInfo("/session/:sessionId/moveto", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(CLICK_COMMAND, new CommandInfo("/session/:sessionId/click", HttpMethod.POST));
    }
}

