/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win.winappdriver;

import com.google.common.base.Throwables;
import dev.pumpo5.win.winappdriver.WinAppDriverProtocolHandshake;
import dev.pumpo5.win.winappdriver.patched.JsonHttpResponseCodec;
import io.appium.java_client.AppiumUserAgentFilter;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;

public class WinAppDriverCommandExecutor
extends AppiumCommandExecutor {
    private static final String IDEMPOTENCY_KEY_HEADER = "X-Idempotency-Key";

    public WinAppDriverCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        super(additionalCommands, addressOfRemoteServer);
    }

    public Response execute(Command command) throws WebDriverException {
        try {
            return "newSession".equals(command.getName()) ? this.createSession(command) : super.execute(command);
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                new WebDriverException(rootCause.getMessage(), rootCause);
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
    }

    private Response createSession(Command command) throws IOException {
        if (this.getCommandCodec() != null) {
            throw new SessionNotCreatedException("Session already exists");
        }
        ProtocolHandshake.Result result = new WinAppDriverProtocolHandshake().createSession(this.getClient().with(httpHandler -> req -> {
            req.setHeader("User-Agent", AppiumUserAgentFilter.buildUserAgent((String)req.getHeader("User-Agent")));
            req.setHeader(IDEMPOTENCY_KEY_HEADER, UUID.randomUUID().toString().toLowerCase());
            return httpHandler.execute(req);
        }), command);
        Dialect dialect = result.getDialect();
        if (!(dialect.getCommandCodec() instanceof W3CHttpCommandCodec)) {
            throw new SessionNotCreatedException("Only W3C sessions are supported. Please make sure your server is up to date.");
        }
        this.setCommandCodec((CommandCodec)new AppiumW3CHttpCommandCodec());
        this.refreshAdditionalCommands();
        this.setResponseCodec((ResponseCodec)new JsonHttpResponseCodec());
        return result.createResponse();
    }
}

