/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win.winappdriver.patched;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class PatchedJsonToWebElementConverter
extends JsonToWebElementConverter {
    private final RemoteWebDriver driver;

    public PatchedJsonToWebElementConverter(RemoteWebDriver driver) {
        super(driver);
        this.driver = driver;
    }

    public Object apply(Object result) {
        if (result instanceof Collection) {
            Collection results = (Collection)result;
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)results, (Function)this));
        }
        if (result instanceof Map) {
            Map resultAsMap = (Map)result;
            String elementKey = this.getElementKey(resultAsMap);
            if (null != elementKey) {
                RemoteWebElement element = this.newRemoteWebElement();
                element.setId(String.valueOf(resultAsMap.get(elementKey)));
                return element;
            }
            return Maps.transformValues((Map)resultAsMap, (Function)this);
        }
        if (result instanceof RemoteWebElement) {
            return this.setOwner((RemoteWebElement)result);
        }
        if (result instanceof Number) {
            if (result instanceof Float || result instanceof Double) {
                return ((Number)result).doubleValue();
            }
            return ((Number)result).longValue();
        }
        return result;
    }

    private RemoteWebElement setOwner(RemoteWebElement element) {
        if (this.driver != null) {
            element.setParent(this.driver);
            element.setFileDetector(this.driver.getFileDetector());
        }
        return element;
    }

    protected RemoteWebElement newRemoteWebElement() {
        return this.setOwner(new RemoteWebElement());
    }

    private String getElementKey(Map<?, ?> resultAsMap) {
        if (resultAsMap.containsKey("ELEMENT")) {
            return "ELEMENT";
        }
        return null;
    }
}

