/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.win.winappdriver.patched;

import dev.pumpo5.win.winappdriver.patched.HandshakeResponse;
import dev.pumpo5.win.winappdriver.patched.InitialHandshakeResponse;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;

public class W3CHandshakeResponse
implements HandshakeResponse {
    @Override
    public Function<InitialHandshakeResponse, ProtocolHandshake.Result> errorHandler() {
        return tuple -> {
            Object rawValue = tuple.getData().get("value");
            if (!(rawValue instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)rawValue;
            Object rawMessage = rawMap.get("message");
            Object rawError = rawMap.get("error");
            Object rawStackTrace = rawMap.get("stacktrace");
            String string = rawStackTrace = rawStackTrace == null ? "" : rawStackTrace;
            if (!(rawError instanceof String) || !(rawMessage instanceof String)) {
                return null;
            }
            if (!(rawStackTrace instanceof String)) {
                rawStackTrace = String.valueOf(rawStackTrace);
            }
            Response response = new Response();
            response.setState((String)rawError);
            response.setStatus(Integer.valueOf(new ErrorCodes().toStatus((String)rawError, Optional.of(tuple.getStatusCode()))));
            Class type = new ErrorCodes().getExceptionType((String)rawError);
            try {
                WebDriverException exception = (WebDriverException)type.getConstructor(String.class).newInstance((String)rawMessage);
                exception.addInfo("remote stacktrace", (String)rawStackTrace);
                response.setValue((Object)exception);
            }
            catch (ReflectiveOperationException e) {
                response.setValue(rawMessage);
            }
            new ErrorHandler().throwIfResponseFailed(response, tuple.getRequestDuration().toMillis());
            return null;
        };
    }

    @Override
    public Function<InitialHandshakeResponse, ProtocolHandshake.Result> successHandler() {
        return tuple -> {
            Object rawValue = tuple.getData().get("value");
            if (!(rawValue instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)rawValue;
            Object rawSessionId = rawMap.get("sessionId");
            Object rawCapabilities = rawMap.get("capabilities");
            if (!(rawSessionId instanceof String) || !(rawCapabilities instanceof Map)) {
                return null;
            }
            for (Object key : ((Map)rawCapabilities).keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            Map caps = (Map)rawCapabilities;
            String sessionId = (String)rawSessionId;
            try {
                Constructor constructor = ProtocolHandshake.Result.class.getDeclaredConstructor(Dialect.class, String.class, Map.class);
                constructor.setAccessible(true);
                return (ProtocolHandshake.Result)constructor.newInstance(Dialect.W3C, sessionId, caps);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

