/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.stores;

import dev.responsive.kafka.internal.utils.Iterators;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;

public class KVStoreStub {
    private final NavigableMap<Bytes, byte[]> records = new TreeMap<Bytes, byte[]>();
    private final Map<Bytes, Long> expiryTimes = new LinkedHashMap<Bytes, Long>();
    private final Duration ttl;
    private final Time time;

    public KVStoreStub(Duration ttl, Time time) {
        this.ttl = ttl;
        this.time = time;
    }

    public long count() {
        this.expireRecords();
        return this.records.size();
    }

    public void put(Bytes key, byte[] value) {
        this.expireRecords();
        if (this.records.containsKey(key)) {
            this.delete(key);
        }
        this.records.put(key, value);
        this.expiryTimes.put(key, this.expirationDateMs());
    }

    public void delete(Bytes key) {
        this.records.remove(key);
    }

    public byte[] get(Bytes key) {
        this.expireRecords();
        return (byte[])this.records.get(key);
    }

    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        this.expireRecords();
        return Iterators.kv(this.records.subMap(from, to).entrySet().iterator(), e -> new KeyValue((Object)((Bytes)e.getKey()), (Object)((byte[])e.getValue())));
    }

    public KeyValueIterator<Bytes, byte[]> all() {
        this.expireRecords();
        return Iterators.kv(this.records.entrySet().iterator(), e -> new KeyValue((Object)((Bytes)e.getKey()), (Object)((byte[])e.getValue())));
    }

    private void expireRecords() {
        Map.Entry<Bytes, Long> entry;
        long now = this.time.milliseconds();
        Iterator<Map.Entry<Bytes, Long>> iter = this.expiryTimes.entrySet().iterator();
        while (iter.hasNext() && (entry = iter.next()).getValue() < now) {
            iter.remove();
            this.records.remove(entry.getKey());
        }
    }

    private long expirationDateMs() {
        if (this.ttl != null) {
            return this.time.milliseconds() + this.ttl.toMillis();
        }
        return Long.MAX_VALUE;
    }
}

