/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.stores;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.RemoteKVTable;
import dev.responsive.kafka.internal.db.spec.CassandraTableSpec;
import dev.responsive.kafka.internal.db.spec.DelegatingTableSpec;
import dev.responsive.kafka.internal.db.spec.TtlTableSpec;
import dev.responsive.kafka.internal.stores.KVStoreStub;
import dev.responsive.kafka.internal.stores.TTDTable;
import java.time.Duration;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;

public class TTDKeyValueTable
extends TTDTable<Bytes>
implements RemoteKVTable {
    private final String name;
    private final KVStoreStub stub;

    public static TTDKeyValueTable create(CassandraTableSpec spec, CassandraClient client) {
        return new TTDKeyValueTable(spec, (TTDCassandraClient)client);
    }

    public TTDKeyValueTable(CassandraTableSpec spec, TTDCassandraClient client) {
        super(client);
        this.name = spec.tableName();
        Duration ttl = null;
        CassandraTableSpec maybeTtlSpec = spec;
        while (maybeTtlSpec instanceof DelegatingTableSpec) {
            if (maybeTtlSpec instanceof TtlTableSpec) {
                ttl = ((TtlTableSpec)maybeTtlSpec).ttl();
                break;
            }
            maybeTtlSpec = ((DelegatingTableSpec)maybeTtlSpec).delegate();
        }
        this.stub = new KVStoreStub(ttl, this.time);
    }

    @Override
    public long count() {
        return this.stub.count();
    }

    public String name() {
        return this.name;
    }

    public BoundStatement insert(int partitionKey, Bytes key, byte[] value, long epochMillis) {
        this.stub.put(key, value);
        return null;
    }

    public BoundStatement delete(int partitionKey, Bytes key) {
        this.stub.delete(key);
        return null;
    }

    public byte[] get(int partition, Bytes key, long minValidTs) {
        return this.stub.get(key);
    }

    public KeyValueIterator<Bytes, byte[]> range(int partition, Bytes from, Bytes to, long minValidTs) {
        return this.stub.range(from, to);
    }

    public KeyValueIterator<Bytes, byte[]> all(int partition, long minValidTs) {
        return this.stub.all();
    }
}

