/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.stores;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.RemoteWindowedTable;
import dev.responsive.kafka.internal.db.spec.CassandraTableSpec;
import dev.responsive.kafka.internal.stores.TTDTable;
import dev.responsive.kafka.internal.stores.WindowStoreStub;
import dev.responsive.kafka.internal.utils.Stamped;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;

public class TTDWindowedTable
extends TTDTable<Stamped<Bytes>>
implements RemoteWindowedTable {
    private final String name;
    private final WindowStoreStub stub;

    public static TTDWindowedTable create(CassandraTableSpec spec, CassandraClient client) {
        return new TTDWindowedTable(spec, (TTDCassandraClient)client);
    }

    public TTDWindowedTable(CassandraTableSpec spec, TTDCassandraClient client) {
        super(client);
        this.name = spec.tableName();
        this.stub = new WindowStoreStub();
    }

    public String name() {
        return this.name;
    }

    public BoundStatement insert(int partitionKey, Stamped<Bytes> key, byte[] value, long epochMillis) {
        this.stub.put(key, value);
        return null;
    }

    public BoundStatement delete(int partitionKey, Stamped<Bytes> key) {
        this.stub.delete(key);
        return null;
    }

    public byte[] fetch(int partition, Bytes key, long windowStart) {
        return this.stub.fetch(key, windowStart);
    }

    public KeyValueIterator<Stamped<Bytes>, byte[]> fetch(int partition, Bytes key, long timeFrom, long timeTo) {
        return this.stub.fetch(key, timeFrom, timeTo);
    }

    public KeyValueIterator<Stamped<Bytes>, byte[]> backFetch(int partition, Bytes key, long timeFrom, long timeTo) {
        return this.stub.backFetch(key, timeFrom, timeTo);
    }

    public KeyValueIterator<Stamped<Bytes>, byte[]> fetchRange(int partition, Bytes fromKey, Bytes toKey, long timeFrom, long timeTo) {
        return this.stub.fetchRange(fromKey, toKey, timeFrom, timeTo);
    }

    public KeyValueIterator<Stamped<Bytes>, byte[]> backFetchRange(int partition, Bytes fromKey, Bytes toKey, long timeFrom, long timeTo) {
        return this.stub.backFetchRange(fromKey, toKey, timeFrom, timeTo);
    }

    public KeyValueIterator<Stamped<Bytes>, byte[]> fetchAll(int partition, long timeFrom, long timeTo) {
        return this.stub.fetchAll(timeFrom, timeTo);
    }

    public KeyValueIterator<Stamped<Bytes>, byte[]> backFetchAll(int partition, long timeFrom, long timeTo) {
        return this.stub.backFetchAll(timeFrom, timeTo);
    }

    @Override
    public long count() {
        return 0L;
    }
}

