/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.clients;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.streams.TTDUtils;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTDMockAdmin
extends MockAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(TTDMockAdmin.class);
    private static final Node BROKER = new Node(0, "dummyHost-1", 1234);
    private final Properties props;
    private final Topology topology;
    private final Set<String> createdTopics = new HashSet<String>();

    public TTDMockAdmin(Properties props, Topology topology) {
        super(Collections.singletonList(BROKER), BROKER);
        this.props = props;
        this.topology = topology;
        LinkedList<String> stateStoreNames = new LinkedList<String>();
        List processors = topology.describe().subtopologies().stream().flatMap(s -> s.nodes().stream()).collect(Collectors.toList());
        for (TopologyDescription.Node node : processors) {
            if (!(node instanceof TopologyDescription.Processor)) continue;
            stateStoreNames.addAll(((TopologyDescription.Processor)node).stores());
        }
        String applicationId = props.getProperty("application.id");
        for (String topic : TTDUtils.deriveChangelogTopic(applicationId, stateStoreNames)) {
            this.addTopic(false, topic, Collections.singletonList(new TopicPartitionInfo(0, BROKER, Collections.emptyList(), Collections.emptyList())), Collections.singletonMap("cleanup.policy", "compact"));
            this.createdTopics.add(topic);
        }
        LOG.debug("Initialized TTD mock admin with changelog topics = [{}]", this.createdTopics);
    }

    public Properties props() {
        return this.props;
    }

    public void verifyChangelogTopicCreation() {
        HashSet<String> missingTopics = new HashSet<String>(TTDUtils.extractChangelogTopics(this.topology));
        missingTopics.retainAll(this.createdTopics);
        if (!missingTopics.isEmpty()) {
            LOG.warn("Not all changelog topics were pre-initialized, missing topics=[{}]", missingTopics);
        }
    }
}

