/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.clients;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import dev.responsive.kafka.api.config.ResponsiveConfig;
import dev.responsive.kafka.internal.clients.TTDMockAdmin;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.QueryOp;
import dev.responsive.kafka.internal.db.RemoteKVTable;
import dev.responsive.kafka.internal.db.RemoteWindowTable;
import dev.responsive.kafka.internal.db.TTDKeyValueTable;
import dev.responsive.kafka.internal.db.TTDWindowTable;
import dev.responsive.kafka.internal.db.TableCache;
import dev.responsive.kafka.internal.db.WindowedTableCache;
import dev.responsive.kafka.internal.db.inmemory.InMemoryKVTable;
import dev.responsive.kafka.internal.stores.ResponsiveStoreRegistry;
import dev.responsive.kafka.internal.utils.RemoteMonitor;
import java.time.Duration;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.utils.Time;

public class TTDCassandraClient
extends CassandraClient {
    private final ResponsiveStoreRegistry storeRegistry = new ResponsiveStoreRegistry();
    private final TTDMockAdmin admin;
    private final Time time;
    private final TableCache<RemoteKVTable<BoundStatement>> kvFactory;
    private final WindowedTableCache<RemoteWindowTable<BoundStatement>> windowedFactory;

    public TTDCassandraClient(TTDMockAdmin admin, Time time) {
        super(ResponsiveConfig.loggedConfig((Map)admin.props()));
        this.admin = admin;
        this.time = time;
        this.kvFactory = new TableCache(spec -> new TTDKeyValueTable(spec, this));
        this.windowedFactory = new WindowedTableCache((spec, partitioner) -> TTDWindowTable.create(spec, this, partitioner));
    }

    public ResponsiveStoreRegistry storeRegistry() {
        return this.storeRegistry;
    }

    public TTDMockAdmin mockAdmin() {
        return this.admin;
    }

    public long currentWallClockTimeMs() {
        return this.time.milliseconds();
    }

    public void advanceWallClockTime(Duration advance) {
        this.time.sleep(advance.toMillis());
    }

    public void flush() {
        this.storeRegistry.stores().forEach(s -> s.onCommit().accept(0L));
    }

    public ResultSet execute(Statement<?> statement) {
        return null;
    }

    public ResultSet execute(String cql) {
        return null;
    }

    public CompletionStage<AsyncResultSet> executeAsync(Statement<?> statement) {
        throw new UnsupportedOperationException("Unexpected method call on TTD stub client");
    }

    public PreparedStatement prepare(SimpleStatement statement, QueryOp operation) {
        throw new UnsupportedOperationException("Unexpected method call on TTD stub client");
    }

    public RemoteMonitor awaitTable(String tableName) {
        return new RemoteMonitor(this.executor, () -> true);
    }

    public long count(String tableName, int tablePartition) {
        InMemoryKVTable kv = (InMemoryKVTable)this.kvFactory.getTable(tableName);
        TTDWindowTable window = (TTDWindowTable)this.windowedFactory.getTable(tableName);
        return (kv == null ? 0L : kv.approximateNumEntries(tablePartition)) + (window == null ? 0L : window.count());
    }

    public OptionalInt numPartitions(String tableName) {
        return OptionalInt.of(1);
    }

    public TableCache<RemoteKVTable<BoundStatement>> kvFactory() {
        return this.kvFactory;
    }

    public TableCache<RemoteKVTable<BoundStatement>> factFactory() {
        return this.kvFactory;
    }

    public WindowedTableCache<RemoteWindowTable<BoundStatement>> windowedFactory() {
        return this.windowedFactory;
    }
}

