/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.db;

import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.db.inmemory.InMemoryKVTable;
import dev.responsive.kafka.internal.db.spec.RemoteTableSpec;
import dev.responsive.kafka.internal.utils.Utils;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;

public class TTDKeyValueTable
extends InMemoryKVTable {
    private final TTDCassandraClient client;

    public TTDKeyValueTable(RemoteTableSpec spec, TTDCassandraClient client) {
        super(spec.tableName(), spec.ttlResolver());
        this.client = client;
    }

    public byte[] get(int kafkaPartition, Bytes key, long streamTimeMs) {
        this.client.flush();
        long currentTimeMs = Math.max(streamTimeMs, this.client.currentWallClockTimeMs());
        return super.get(kafkaPartition, key, currentTimeMs);
    }

    public KeyValueIterator<Bytes, byte[]> range(int kafkaPartition, Bytes from, Bytes to, long streamTimeMs) {
        this.client.flush();
        long currentTimeMs = Math.max(streamTimeMs, this.client.currentWallClockTimeMs());
        return super.range(kafkaPartition, from, to, currentTimeMs);
    }

    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefix(P prefix, PS prefixKeySerializer, int kafkaPartition, long streamTimeMs) {
        Bytes from = Bytes.wrap((byte[])prefixKeySerializer.serialize(null, prefix));
        Bytes to = Utils.incrementWithoutOverflow((Bytes)from);
        return this.range(kafkaPartition, from, to, streamTimeMs);
    }

    public KeyValueIterator<Bytes, byte[]> all(int kafkaPartition, long streamTimeMs) {
        this.client.flush();
        long currentTimeMs = Math.max(streamTimeMs, this.client.currentWallClockTimeMs());
        return super.all(kafkaPartition, currentTimeMs);
    }

    public long approximateNumEntries(int kafkaPartition) {
        return this.client.count(this.name(), kafkaPartition);
    }
}

