/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.stores;

import dev.responsive.kafka.internal.utils.WindowedKey;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;

public class WindowStoreStub {
    final Comparator<WindowedKey> keyComparator = Comparator.comparing(k -> k.key);
    private final NavigableMap<WindowedKey, byte[]> records = new TreeMap<WindowedKey, byte[]>(this.keyComparator.thenComparingLong(k -> k.windowStartMs));
    private final long retentionPeriod;
    private long observedStreamTime = 0L;

    public WindowStoreStub(long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public void put(WindowedKey key, byte[] value) {
        this.observedStreamTime = Math.max(this.observedStreamTime, key.windowStartMs);
        this.records.put(key, value);
    }

    public void delete(WindowedKey key) {
        this.observedStreamTime = Math.max(this.observedStreamTime, key.windowStartMs);
        this.records.remove(key);
    }

    public byte[] fetch(Bytes key, long windowStart) {
        WindowedKey windowedKey = new WindowedKey(key, windowStart);
        if (windowStart > this.minValidTimestamp() && this.records.containsKey(windowedKey)) {
            return (byte[])this.records.get(windowedKey);
        }
        return null;
    }

    public KeyValueIterator<WindowedKey, byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public KeyValueIterator<WindowedKey, byte[]> backFetch(Bytes key, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public KeyValueIterator<WindowedKey, byte[]> fetchRange(Bytes fromKey, Bytes toKey, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public KeyValueIterator<WindowedKey, byte[]> backFetchRange(Bytes fromKey, Bytes toKey, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public KeyValueIterator<WindowedKey, byte[]> fetchAll(long timeFrom, long timeTo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public KeyValueIterator<WindowedKey, byte[]> backFetchAll(long timeFrom, long timeTo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private long minValidTimestamp() {
        return this.observedStreamTime - this.retentionPeriod + 1L;
    }
}

