/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Instant;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.test.TestRecord;

public final class TTDUtils {
    public static Set<String> deriveChangelogTopic(String appId, List<String> stores) {
        return stores.stream().map(s -> ProcessorStateManager.storeChangelogTopic((String)appId, (String)s, null)).collect(Collectors.toSet());
    }

    public static Set<String> extractChangelogTopics(Topology topology) {
        return topology.internalTopologyBuilder.subtopologyToTopicsInfo().values().stream().flatMap(t -> t.stateChangelogTopics.keySet().stream()).collect(Collectors.toSet());
    }

    public static class TopologyTestDriverAccessor
    extends TopologyTestDriver {
        private final Properties props;

        public TopologyTestDriverAccessor(Topology topology, Properties config, Instant initialWallClockTime) {
            super(topology, config, initialWallClockTime);
            this.props = config;
        }

        public Properties props() {
            return this.props;
        }

        protected <K, V> void pipeRecord(String topic, TestRecord<K, V> record, Serializer<K> keySerializer, Serializer<V> valueSerializer, Instant time) {
            super.pipeRecord(topic, record, keySerializer, valueSerializer, time);
        }
    }
}

