/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import dev.robocode.tankroyale.botapi.BotInfo;
import dev.robocode.tankroyale.botapi.BulletState;
import dev.robocode.tankroyale.botapi.Color;
import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import java.net.URI;
import java.util.Collection;
import java.util.List;

public abstract class BaseBot
implements IBaseBot {
    final BaseBotInternals __baseBotInternals;

    public BaseBot() {
        this.__baseBotInternals = new BaseBotInternals(this, null, null, null);
    }

    public BaseBot(BotInfo botInfo) {
        this.__baseBotInternals = new BaseBotInternals(this, botInfo, null, null);
    }

    public BaseBot(BotInfo botInfo, URI serverUrl) {
        this.__baseBotInternals = new BaseBotInternals(this, botInfo, serverUrl, null);
    }

    public BaseBot(BotInfo botInfo, URI serverUrl, String serverSecret) {
        this.__baseBotInternals = new BaseBotInternals(this, botInfo, serverUrl, serverSecret);
    }

    @Override
    public final void start() {
        this.__baseBotInternals.start();
    }

    @Override
    public final void go() {
        this.__baseBotInternals.execute();
    }

    @Override
    public final String getVariant() {
        return this.__baseBotInternals.getVariant();
    }

    @Override
    public final String getVersion() {
        return this.__baseBotInternals.getVersion();
    }

    @Override
    public final int getMyId() {
        return this.__baseBotInternals.getMyId();
    }

    @Override
    public final String getGameType() {
        return this.__baseBotInternals.getGameSetup().getGameType();
    }

    @Override
    public final int getArenaWidth() {
        return this.__baseBotInternals.getGameSetup().getArenaWidth();
    }

    @Override
    public final int getArenaHeight() {
        return this.__baseBotInternals.getGameSetup().getArenaHeight();
    }

    @Override
    public final int getNumberOfRounds() {
        return this.__baseBotInternals.getGameSetup().getNumberOfRounds();
    }

    @Override
    public final double getGunCoolingRate() {
        return this.__baseBotInternals.getGameSetup().getGunCoolingRate();
    }

    @Override
    public final int getMaxInactivityTurns() {
        return this.__baseBotInternals.getGameSetup().getMaxInactivityTurns();
    }

    @Override
    public final int getTurnTimeout() {
        return this.__baseBotInternals.getGameSetup().getTurnTimeout();
    }

    @Override
    public final int getTimeLeft() {
        return this.__baseBotInternals.getTimeLeft();
    }

    @Override
    public final int getRoundNumber() {
        return this.__baseBotInternals.getCurrentTick().getRoundNumber();
    }

    @Override
    public final int getTurnNumber() {
        return this.__baseBotInternals.getCurrentTick().getTurnNumber();
    }

    @Override
    public final int getEnemyCount() {
        return this.__baseBotInternals.getCurrentTick().getEnemyCount();
    }

    @Override
    public final double getEnergy() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getEnergy();
    }

    @Override
    public final boolean isDisabled() {
        return this.getEnergy() == 0.0;
    }

    @Override
    public final double getX() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getX();
    }

    @Override
    public final double getY() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getY();
    }

    @Override
    public final double getDirection() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getDirection();
    }

    @Override
    public final double getGunDirection() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getGunDirection();
    }

    @Override
    public final double getRadarDirection() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getRadarDirection();
    }

    @Override
    public final double getSpeed() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getSpeed();
    }

    @Override
    public final double getGunHeat() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getGunHeat();
    }

    @Override
    public final Collection<BulletState> getBulletStates() {
        return this.__baseBotInternals.getCurrentTick().getBulletStates();
    }

    @Override
    public final List<BotEvent> getEvents() {
        return this.__baseBotInternals.getEvents();
    }

    @Override
    public final void clearEvents() {
        this.__baseBotInternals.clearEvents();
    }

    @Override
    public final double getTurnRate() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getTurnRate();
    }

    @Override
    public void setTurnRate(double turnRate) {
        if (Double.isNaN(turnRate)) {
            throw new IllegalArgumentException("turnRate cannot be NaN");
        }
        this.__baseBotInternals.getBotIntent().setTurnRate(turnRate);
    }

    @Override
    public final double getMaxTurnRate() {
        return this.__baseBotInternals.getMaxTurnRate();
    }

    @Override
    public final void setMaxTurnRate(double maxTurnRate) {
        this.__baseBotInternals.setMaxTurnRate(maxTurnRate);
    }

    @Override
    public final double getGunTurnRate() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getGunTurnRate();
    }

    @Override
    public void setGunTurnRate(double gunTurnRate) {
        if (Double.isNaN(gunTurnRate)) {
            throw new IllegalArgumentException("gunTurnRate cannot be NaN");
        }
        this.__baseBotInternals.getBotIntent().setGunTurnRate(gunTurnRate);
    }

    @Override
    public final double getMaxGunTurnRate() {
        return this.__baseBotInternals.getMaxGunTurnRate();
    }

    @Override
    public final void setMaxGunTurnRate(double maxGunTurnRate) {
        this.__baseBotInternals.setMaxGunTurnRate(maxGunTurnRate);
    }

    @Override
    public final double getRadarTurnRate() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getRadarTurnRate();
    }

    @Override
    public void setRadarTurnRate(double radarTurnRate) {
        if (Double.isNaN(radarTurnRate)) {
            throw new IllegalArgumentException("radarTurnRate cannot be NaN");
        }
        this.__baseBotInternals.getBotIntent().setRadarTurnRate(radarTurnRate);
    }

    @Override
    public final double getMaxRadarTurnRate() {
        return this.__baseBotInternals.getMaxRadarTurnRate();
    }

    @Override
    public final void setMaxRadarTurnRate(double maxRadarTurnRate) {
        this.__baseBotInternals.setMaxRadarTurnRate(maxRadarTurnRate);
    }

    @Override
    public final double getTargetSpeed() {
        Double targetSpeed = this.__baseBotInternals.getBotIntent().getTargetSpeed();
        return targetSpeed == null ? 0.0 : targetSpeed;
    }

    @Override
    public void setTargetSpeed(double targetSpeed) {
        if (Double.isNaN(targetSpeed)) {
            throw new IllegalArgumentException("targetSpeed cannot be NaN");
        }
        this.__baseBotInternals.getBotIntent().setTargetSpeed(targetSpeed);
    }

    @Override
    public final double getMaxSpeed() {
        return this.__baseBotInternals.getMaxSpeed();
    }

    @Override
    public final void setMaxSpeed(double maxSpeed) {
        this.__baseBotInternals.setMaxSpeed(maxSpeed);
    }

    @Override
    public final boolean setFire(double firepower) {
        return this.__baseBotInternals.setFire(firepower);
    }

    @Override
    public final double getFirepower() {
        Double firepower = this.__baseBotInternals.getBotIntent().getFirepower();
        return firepower == null ? 0.0 : firepower;
    }

    @Override
    public final void setRescan() {
        this.__baseBotInternals.getBotIntent().setRescan(true);
    }

    @Override
    public final void setInterruptible(boolean interruptible) {
        this.__baseBotInternals.setInterruptible(interruptible);
    }

    @Override
    public final void setAdjustGunForBodyTurn(boolean adjust) {
        this.__baseBotInternals.getBotIntent().setAdjustGunForBodyTurn(adjust);
    }

    @Override
    public final boolean isAdjustGunForBodyTurn() {
        Boolean adjust = this.__baseBotInternals.getBotIntent().getAdjustGunForBodyTurn();
        return adjust != null && adjust != false;
    }

    @Override
    public final void setAdjustRadarForBodyTurn(boolean adjust) {
        this.__baseBotInternals.getBotIntent().setAdjustRadarForBodyTurn(adjust);
    }

    @Override
    public final boolean isAdjustRadarForBodyTurn() {
        Boolean adjust = this.__baseBotInternals.getBotIntent().getAdjustRadarForBodyTurn();
        return adjust != null && adjust != false;
    }

    @Override
    public final void setAdjustRadarForGunTurn(boolean adjust) {
        this.__baseBotInternals.getBotIntent().setAdjustRadarForGunTurn(adjust);
    }

    @Override
    public final boolean isAdjustRadarForGunTurn() {
        Boolean adjust = this.__baseBotInternals.getBotIntent().getAdjustRadarForGunTurn();
        return adjust != null && adjust != false;
    }

    @Override
    public final void addCustomEvent(Condition condition) {
        this.__baseBotInternals.addCondition(condition);
    }

    @Override
    public final void removeCustomEvent(Condition condition) {
        this.__baseBotInternals.removeCondition(condition);
    }

    @Override
    public void setStop() {
        this.__baseBotInternals.setStop();
    }

    @Override
    public void setResume() {
        this.__baseBotInternals.setResume();
    }

    @Override
    public boolean isStopped() {
        return this.__baseBotInternals.isStopped();
    }

    @Override
    public final Color getBodyColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getBodyColor();
    }

    @Override
    public final void setBodyColor(Color bodyColor) {
        this.__baseBotInternals.getBotIntent().setBodyColor(BaseBot.toIntentColor(bodyColor));
    }

    @Override
    public final Color getTurretColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getTurretColor();
    }

    @Override
    public final void setTurretColor(Color turretColor) {
        this.__baseBotInternals.getBotIntent().setTurretColor(BaseBot.toIntentColor(turretColor));
    }

    @Override
    public final Color getRadarColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getRadarColor();
    }

    @Override
    public final void setRadarColor(Color radarColor) {
        this.__baseBotInternals.getBotIntent().setRadarColor(BaseBot.toIntentColor(radarColor));
    }

    @Override
    public final Color getBulletColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getBulletColor();
    }

    @Override
    public final void setBulletColor(Color bulletColor) {
        this.__baseBotInternals.getBotIntent().setBulletColor(BaseBot.toIntentColor(bulletColor));
    }

    @Override
    public final Color getScanColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getScanColor();
    }

    @Override
    public final void setScanColor(Color scanColor) {
        this.__baseBotInternals.getBotIntent().setScanColor(BaseBot.toIntentColor(scanColor));
    }

    @Override
    public final Color getTracksColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getTracksColor();
    }

    @Override
    public final void setTracksColor(Color tracksColor) {
        this.__baseBotInternals.getBotIntent().setTracksColor(BaseBot.toIntentColor(tracksColor));
    }

    @Override
    public final Color getGunColor() {
        return this.__baseBotInternals.getCurrentTick().getBotState().getGunColor();
    }

    @Override
    public final void setGunColor(Color gunColor) {
        this.__baseBotInternals.getBotIntent().setGunColor(BaseBot.toIntentColor(gunColor));
    }

    @Override
    public final double calcMaxTurnRate(double speed) {
        return 10.0 - 0.75 * Math.abs(speed);
    }

    @Override
    public final double calcBulletSpeed(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    @Override
    public final double calcGunHeat(double firepower) {
        return 1.0 + firepower / 5.0;
    }

    @Override
    public int getEventPriority(Class<BotEvent> eventClass) {
        return this.__baseBotInternals.getPriority(eventClass);
    }

    @Override
    public void setEventPriority(Class<BotEvent> eventClass, int priority) {
        this.__baseBotInternals.setPriority(eventClass, priority);
    }

    private static String toIntentColor(Color color) {
        return color == null ? null : "#" + color.toHex();
    }
}

