/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.neovisionaries.i18n.CountryCode;
import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.InitialPosition;
import dev.robocode.tankroyale.botapi.util.CollectionUtil;
import dev.robocode.tankroyale.botapi.util.CountryCodeUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class BotInfo {
    public static final int MAX_NAME_LENGTH = 30;
    public static final int MAX_VERSION_LENGTH = 20;
    public static final int MAX_AUTHOR_LENGTH = 50;
    public static final int MAX_DESCRIPTION_LENGTH = 250;
    public static final int MAX_HOMEPAGE_LENGTH = 150;
    public static final int MAX_GAME_TYPE_LENGTH = 20;
    public static final int MAX_PLATFORM_LENGTH = 30;
    public static final int MAX_PROGRAMMING_LANG_LENGTH = 30;
    public static final int MAX_NUMBER_OF_AUTHORS = 5;
    public static final int MAX_NUMBER_OF_COUNTRY_CODES = 5;
    public static final int MAX_NUMBER_OF_GAME_TYPES = 10;
    private final String name;
    private final String version;
    private final List<String> authors;
    private final String description;
    private final String homepage;
    private final List<String> countryCodes;
    private final Set<String> gameTypes;
    private final String platform;
    private final String programmingLang;
    private final InitialPosition initialPosition;

    public BotInfo(String name, String version, List<String> authors, String description, String homepage, List<String> countryCodes, Collection<String> gameTypes, String platform, String programmingLang, InitialPosition initialPosition) {
        this.name = BotInfo.processName(name);
        this.version = BotInfo.processVersion(version);
        this.authors = BotInfo.processAuthors(authors);
        this.description = BotInfo.processDescription(description);
        this.homepage = BotInfo.processHomepage(homepage);
        this.countryCodes = BotInfo.processCountryCodes(countryCodes);
        this.gameTypes = BotInfo.processGameTypes(gameTypes);
        this.platform = BotInfo.processPlatform(platform);
        this.programmingLang = BotInfo.processProgrammingLang(programmingLang);
        this.initialPosition = initialPosition;
    }

    public static IBuilder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public Set<String> getGameTypes() {
        return this.gameTypes;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getProgrammingLang() {
        return this.programmingLang;
    }

    public InitialPosition getInitialPosition() {
        return this.initialPosition;
    }

    public static BotInfo fromResourceFile(String filename) {
        BotInfo botInfo;
        block9: {
            InputStream is = BotInfo.class.getResourceAsStream(filename);
            try {
                if (is == null) {
                    throw new FileNotFoundException("File not found: " + filename);
                }
                botInfo = BotInfo.fromInputStream(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new BotException("Could not read the resource file: " + filename, ioe);
                }
            }
            is.close();
        }
        return botInfo;
    }

    public static BotInfo fromFile(String filename) {
        BotInfo botInfo;
        FileInputStream is = new FileInputStream(filename);
        try {
            botInfo = BotInfo.fromInputStream(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new BotException("Could not read the file: " + filename, ioe);
            }
        }
        ((InputStream)is).close();
        return botInfo;
    }

    public static BotInfo fromInputStream(InputStream inputStream) {
        Gson gson = new Gson();
        JsonReader reader = new JsonReader(new InputStreamReader(inputStream));
        JsonProperties data = (JsonProperties)gson.fromJson(reader, (Type)((Object)JsonProperties.class));
        BotInfo.throwExceptionIfJsonFieldIsBlank(data.name);
        BotInfo.throwExceptionIfJsonFieldIsBlank(data.version);
        BotInfo.throwExceptionIfJsonFieldIsBlank(data.authors);
        BotInfo.throwExceptionIfJsonFieldIsBlank(data.gameTypes);
        String countryCodes = data.countryCodes;
        if (countryCodes == null) {
            countryCodes = "";
        }
        return new BotInfo(data.name, data.version, Arrays.asList(data.authors.split("\\s*,\\s*")), data.description, data.homepage, Arrays.asList(countryCodes.split("\\s*,\\s*")), new HashSet<String>(Arrays.asList(data.gameTypes.split("\\s*,\\s*"))), data.platform, data.programmingLang, InitialPosition.fromString(data.initialPosition));
    }

    private static String processName(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Name cannot be null, empty or blank");
        }
        if ((name = name.trim()).length() > 30) {
            throw new IllegalArgumentException("Name length exceeds the maximum of 30 characters");
        }
        return name;
    }

    private static String processVersion(String version) {
        if (version == null || version.isBlank()) {
            throw new IllegalArgumentException("Version cannot be null, empty or blank");
        }
        if ((version = version.trim()).length() > 20) {
            throw new IllegalArgumentException("Version length exceeds the maximum of 20 characters");
        }
        return version;
    }

    private static List<String> processAuthors(List<String> authors) {
        if (BotInfo.isNullOrEmptyOrContainsBlanks(authors)) {
            throw new IllegalArgumentException("Authors cannot be null or empty or contain blanks");
        }
        if (authors.size() > 5) {
            throw new IllegalArgumentException("Number of authors exceeds the maximum of 5");
        }
        ArrayList<String> authorsCopy = new ArrayList<String>();
        authors.stream().filter(Objects::nonNull).forEach(author -> {
            if ((author = author.trim()).length() > 50) {
                throw new IllegalArgumentException("Author length exceeds the maximum of 50 characters");
            }
            authorsCopy.add((String)author);
        });
        authorsCopy.removeIf(String::isBlank);
        return authorsCopy;
    }

    private static String processDescription(String description) {
        if (description != null && description.trim().length() > 250) {
            throw new IllegalArgumentException("Description length exceeds the maximum of 250 characters");
        }
        return BotInfo.toNullIfBlankElseTrim(description);
    }

    private static String processHomepage(String homepage) {
        if (homepage != null && homepage.trim().length() > 150) {
            throw new IllegalArgumentException("Homepage length exceeds the maximum of 150 characters");
        }
        return BotInfo.toNullIfBlankElseTrim(homepage);
    }

    private static List<String> processCountryCodes(List<String> countryCodeStrings) {
        CountryCode countryCode2;
        ArrayList<CountryCode> countryCodes = new ArrayList<CountryCode>();
        if (countryCodeStrings != null) {
            countryCodeStrings.stream().filter(Objects::nonNull).forEach(string -> {
                CountryCode countryCode = CountryCodeUtil.toCountryCode(string);
                if (countryCode != null) {
                    countryCodes.add(countryCode);
                }
            });
        }
        if (countryCodes.isEmpty() && (countryCode2 = CountryCodeUtil.toCountryCode(CountryCodeUtil.getLocalCountryCode())) != null) {
            countryCodes.add(countryCode2);
        }
        if (countryCodes.size() > 5) {
            throw new IllegalArgumentException("Number of country codes exceeds the maximum of 5");
        }
        ArrayList<String> countryCodesAlpha2 = new ArrayList<String>();
        countryCodes.forEach(countryCode -> countryCodesAlpha2.add(countryCode.getAlpha2()));
        return countryCodesAlpha2;
    }

    private static Set<String> processGameTypes(Collection<String> gameTypes) {
        if (BotInfo.isNullOrEmptyOrContainsBlanks(gameTypes)) {
            throw new IllegalArgumentException("Game types cannot be null or empty or contain blanks");
        }
        if (gameTypes.size() > 10) {
            throw new IllegalArgumentException("Number of game types exceeds the maximum of 10");
        }
        HashSet<String> gameTypesCopy = new HashSet<String>();
        gameTypes.stream().filter(Objects::nonNull).forEach(gameType -> {
            if ((gameType = gameType.trim()).length() > 20) {
                throw new IllegalArgumentException("Game type length exceeds the maximum of 20 characters");
            }
            gameTypesCopy.add((String)gameType);
        });
        gameTypesCopy.removeIf(String::isBlank);
        return gameTypesCopy;
    }

    private static String processPlatform(String platform) {
        if (platform == null || platform.trim().length() == 0) {
            return "Java Runtime Environment (JRE) " + System.getProperty("java.version");
        }
        if (platform.trim().length() > 30) {
            throw new IllegalArgumentException("Platform length exceeds the maximum of 30 characters");
        }
        return BotInfo.toNullIfBlankElseTrim(platform);
    }

    private static String processProgrammingLang(String programmingLang) {
        if (programmingLang != null && programmingLang.trim().length() > 30) {
            throw new IllegalArgumentException("ProgrammingLang length exceeds the maximum of 30 characters");
        }
        return BotInfo.toNullIfBlankElseTrim(programmingLang);
    }

    private static void throwExceptionIfJsonFieldIsBlank(String fieldName) {
        if (fieldName == null || fieldName.isBlank()) {
            throw new IllegalArgumentException("The required field '" + fieldName + "' is missing or blank");
        }
    }

    private static boolean isNullOrEmptyOrContainsBlanks(Collection<String> collection) {
        return collection == null || collection.isEmpty() || collection.stream().allMatch(String::isBlank);
    }

    private static String toNullIfBlankElseTrim(String value) {
        return value == null ? null : (value.isBlank() ? null : value.trim());
    }

    private static final class Builder
    implements IBuilder {
        private String name;
        private String version;
        private List<String> authors = new ArrayList<String>();
        private String description;
        private String homepage;
        private List<String> countryCodes = new ArrayList<String>();
        private Set<String> gameTypes = new HashSet<String>();
        private String platform;
        private String programmingLang;
        private InitialPosition initialPosition;

        private Builder() {
        }

        @Override
        public BotInfo build() {
            return new BotInfo(this.name, this.version, this.authors, this.description, this.homepage, this.countryCodes, this.gameTypes, this.platform, this.programmingLang, this.initialPosition);
        }

        @Override
        public IBuilder copy(BotInfo botInfo) {
            this.name = botInfo.getName();
            this.version = botInfo.getVersion();
            this.authors = botInfo.getAuthors();
            this.description = botInfo.getDescription();
            this.homepage = botInfo.getHomepage();
            this.countryCodes = botInfo.getCountryCodes();
            this.gameTypes = botInfo.getGameTypes();
            this.platform = botInfo.getPlatform();
            this.programmingLang = botInfo.getProgrammingLang();
            this.initialPosition = botInfo.getInitialPosition();
            return this;
        }

        @Override
        public IBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        @Override
        public IBuilder setAuthors(List<String> authors) {
            this.authors = CollectionUtil.toMutableList(authors);
            return this;
        }

        @Override
        public IBuilder addAuthor(String author) {
            this.authors.add(author);
            return this;
        }

        @Override
        public IBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public IBuilder setHomepage(String homepage) {
            this.homepage = homepage;
            return this;
        }

        @Override
        public IBuilder setCountryCodes(List<String> countryCodes) {
            this.countryCodes = CollectionUtil.toMutableList(countryCodes);
            return this;
        }

        @Override
        public IBuilder addCountryCode(String countryCode) {
            this.countryCodes.add(countryCode);
            return this;
        }

        @Override
        public IBuilder setGameTypes(List<String> gameTypes) {
            this.gameTypes = CollectionUtil.toMutableSet(gameTypes);
            return this;
        }

        @Override
        public IBuilder addGameType(String gameType) {
            this.gameTypes.add(gameType);
            return this;
        }

        @Override
        public IBuilder setPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public IBuilder setProgrammingLang(String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        @Override
        public IBuilder setInitialPosition(InitialPosition initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }
    }

    private static class JsonProperties {
        String name;
        String version;
        String authors;
        String description;
        String homepage;
        String countryCodes;
        String gameTypes;
        String platform;
        String programmingLang;
        String initialPosition;

        private JsonProperties() {
        }
    }

    public static interface IBuilder {
        public BotInfo build();

        public IBuilder copy(BotInfo var1);

        public IBuilder setName(String var1);

        public IBuilder setVersion(String var1);

        public IBuilder setAuthors(List<String> var1);

        public IBuilder addAuthor(String var1);

        public IBuilder setDescription(String var1);

        public IBuilder setHomepage(String var1);

        public IBuilder setCountryCodes(List<String> var1);

        public IBuilder addCountryCode(String var1);

        public IBuilder setGameTypes(List<String> var1);

        public IBuilder addGameType(String var1);

        public IBuilder setPlatform(String var1);

        public IBuilder setProgrammingLang(String var1);

        public IBuilder setInitialPosition(InitialPosition var1);
    }
}

