/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import java.util.Objects;
import java.util.regex.Pattern;

public class Color {
    private static final Pattern NUMERIC_RGB = Pattern.compile("^#[0-9a-fA-F]{3,6}$");
    private static final Pattern THREE_HEX_DIGITS = Pattern.compile("^[0-9a-fA-F]{3}$");
    private static final Pattern SIX_HEX_DIGITS = Pattern.compile("^[0-9a-fA-F]{6}$");
    public static final Color WHITE = Color.fromHex("FFFFFF");
    public static final Color SILVER = Color.fromHex("C0C0C0");
    public static final Color GRAY = Color.fromHex("808080");
    public static final Color BLACK = Color.fromHex("000000");
    public static final Color RED = Color.fromHex("FF0000");
    public static final Color MAROON = Color.fromHex("800000");
    public static final Color YELLOW = Color.fromHex("FFFF00");
    public static final Color OLIVE = Color.fromHex("808000");
    public static final Color LIME = Color.fromHex("00FF00");
    public static final Color GREEN = Color.fromHex("008000");
    public static final Color CYAN = Color.fromHex("00FFFF");
    public static final Color TEAL = Color.fromHex("008080");
    public static final Color BLUE = Color.fromHex("0000FF");
    public static final Color NAVY = Color.fromHex("000080");
    public static final Color FUCHSIA = Color.fromHex("FF00FF");
    public static final Color PURPLE = Color.fromHex("800080");
    public static final Color ORANGE = Color.fromHex("FF8000");
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("The 'red' color component must be in the range 0 - 255");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("The 'green' color component must be in the range 0 - 255");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("The 'blue' color component must be in the range 0 - 255");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public String toHex() {
        return Color.toHex(this.red) + Color.toHex(this.green) + Color.toHex(this.blue);
    }

    private static String toHex(int value) {
        return Integer.toHexString(value >> 4) + Integer.toHexString(value & 0xF);
    }

    public static Color fromString(String str) {
        if (str == null) {
            return null;
        }
        if (NUMERIC_RGB.matcher(str = str.trim()).matches()) {
            return Color.fromHex(str.substring(1));
        }
        throw new IllegalArgumentException("You must supply the string in numeric RGB format #[0-9a-fA-F], e.g. \"#09C\" or \"#0099CC\"");
    }

    public static Color fromHex(String hexTriplet) {
        if (THREE_HEX_DIGITS.matcher(hexTriplet = hexTriplet.trim()).matches()) {
            return Color.fromThreeHexDigits(hexTriplet);
        }
        if (SIX_HEX_DIGITS.matcher(hexTriplet).matches()) {
            return Color.fromSixHexDigits(hexTriplet);
        }
        throw new IllegalArgumentException("You must supply 3 or 6 hex digits [0-9a-fA-F], e.g. \"09C\" or \"0099CC\"");
    }

    private static Color fromThreeHexDigits(String threeHexDigits) {
        int r = Integer.valueOf(threeHexDigits.substring(0, 1), 16);
        int g = Integer.valueOf(threeHexDigits.substring(1, 2), 16);
        int b = Integer.valueOf(threeHexDigits.substring(2, 3), 16);
        r = r << 4 | r;
        g = g << 4 | g;
        b = b << 4 | b;
        return new Color(r, g, b);
    }

    private static Color fromSixHexDigits(String sixHexDigits) {
        int r = Integer.valueOf(sixHexDigits.substring(0, 2), 16);
        int g = Integer.valueOf(sixHexDigits.substring(2, 4), 16);
        int b = Integer.valueOf(sixHexDigits.substring(4, 6), 16);
        return new Color(r, g, b);
    }

    protected boolean equals(Color other) {
        return this.red == other.red && this.green == other.green && this.blue == other.blue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.equals((Color)o);
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue);
    }

    public String toString() {
        return this.toHex();
    }
}

