/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import java.io.Serializable;
import java.util.Objects;

public final class InitialPosition {
    private final Double x;
    private final Double y;
    private final Double angle;

    private InitialPosition(Double x, Double y, Double angle) {
        this.x = x;
        this.y = y;
        this.angle = angle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitialPosition that = (InitialPosition)o;
        return Objects.equals(this.x, that.x) && Objects.equals(this.y, that.y) && Objects.equals(this.angle, that.angle);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.angle);
    }

    public Double getX() {
        return this.x;
    }

    public Double getY() {
        return this.y;
    }

    public Double getAngle() {
        return this.angle;
    }

    public String toString() {
        if (this.x == null && this.y == null && this.angle == null) {
            return "";
        }
        Object x = this.x == null ? "" : this.x;
        Object y = this.y == null ? "" : this.y;
        Object angle = this.angle == null ? "" : this.angle;
        return (Serializable)x + "," + (Serializable)y + "," + (Serializable)angle;
    }

    public static InitialPosition fromString(String initialPosition) {
        if (initialPosition == null || initialPosition.isBlank()) {
            return null;
        }
        String[] values = initialPosition.trim().split("\\s*,\\s*|\\s+");
        return InitialPosition.parseInitialPosition(values);
    }

    private static InitialPosition parseInitialPosition(String[] values) {
        if (values.length < 1) {
            return null;
        }
        Double x = InitialPosition.parseDouble(values[0]);
        if (values.length < 2) {
            return new InitialPosition(x, null, null);
        }
        Double y = InitialPosition.parseDouble(values[1]);
        Double angle = null;
        if (values.length >= 3) {
            angle = InitialPosition.parseDouble(values[2]);
        }
        return new InitialPosition(x, y, angle);
    }

    private static Double parseDouble(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Double.parseDouble(str.trim());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

