/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.BotInfo;
import dev.robocode.tankroyale.botapi.GameSetup;
import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.ConnectedEvent;
import dev.robocode.tankroyale.botapi.events.ConnectionErrorEvent;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.GameStartedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.RoundEndedEvent;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.BotHandshakeFactory;
import dev.robocode.tankroyale.botapi.internal.EnvVars;
import dev.robocode.tankroyale.botapi.internal.EventQueue;
import dev.robocode.tankroyale.botapi.internal.IStopResumeListener;
import dev.robocode.tankroyale.botapi.internal.InterruptEventHandlerException;
import dev.robocode.tankroyale.botapi.mapper.EventMapper;
import dev.robocode.tankroyale.botapi.mapper.GameSetupMapper;
import dev.robocode.tankroyale.botapi.mapper.ResultsMapper;
import dev.robocode.tankroyale.botapi.util.MathUtil;
import dev.robocode.tankroyale.schema.BotDeathEvent;
import dev.robocode.tankroyale.schema.BotHandshake;
import dev.robocode.tankroyale.schema.BotHitBotEvent;
import dev.robocode.tankroyale.schema.BotHitWallEvent;
import dev.robocode.tankroyale.schema.BotIntent;
import dev.robocode.tankroyale.schema.BotReady;
import dev.robocode.tankroyale.schema.BulletFiredEvent;
import dev.robocode.tankroyale.schema.BulletHitBotEvent;
import dev.robocode.tankroyale.schema.BulletHitBulletEvent;
import dev.robocode.tankroyale.schema.Event;
import dev.robocode.tankroyale.schema.GameEndedEventForBot;
import dev.robocode.tankroyale.schema.GameStartedEventForBot;
import dev.robocode.tankroyale.schema.Message;
import dev.robocode.tankroyale.schema.ScannedBotEvent;
import dev.robocode.tankroyale.schema.ServerHandshake;
import dev.robocode.tankroyale.schema.TickEventForBot;
import dev.robocode.tankroyale.schema.WonRoundEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BaseBotInternals {
    private static final String DEFAULT_SERVER_URL = "ws://localhost:7654";
    private static final String SERVER_URL_PROPERTY_KEY = "server.url";
    private static final String SERVER_SECRET_PROPERTY_KEY = "server.secret";
    private static final String NOT_CONNECTED_TO_SERVER_MSG = "Not connected to a game server. Make sure onConnected() event handler has been called first";
    private static final String GAME_NOT_RUNNING_MSG = "Game is not running. Make sure onGameStarted() event handler has been called first";
    private static final String TICK_NOT_AVAILABLE_MSG = "Game is not running or tick has not occurred yet. Make sure onTick() event handler has been called first";
    private final URI serverUrl;
    private final String serverSecret;
    private WebSocket socket;
    private ServerHandshake serverHandshake;
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    private final IBaseBot baseBot;
    private final BotInfo botInfo;
    private BotIntent botIntent = BaseBotInternals.newBotIntent();
    private Integer myId;
    private GameSetup gameSetup;
    private TickEvent tickEvent;
    private Long tickStartNanoTime;
    private final EventQueue eventQueue;
    private final BotEventHandlers botEventHandlers;
    private final Set<Condition> conditions = new HashSet<Condition>();
    private final Object nextTurnMonitor = new Object();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private boolean isStopped;
    private IStopResumeListener stopResumeListener;
    private double maxSpeed = 8.0;
    private double maxTurnRate = 10.0;
    private double maxGunTurnRate = 20.0;
    private double maxRadarTurnRate = 45.0;
    private Double savedTargetSpeed;
    private Double savedTurnRate;
    private Double savedGunTurnRate;
    private Double savedRadarTurnRate;
    private final double absDeceleration = Math.abs(-2);
    private final Gson gson;
    private boolean eventHandlingDisabled;
    private final Map<Class<? extends BotEvent>, Integer> eventPriorities = new HashMap<Class<? extends BotEvent>, Integer>();

    public BaseBotInternals(IBaseBot baseBot, BotInfo botInfo, URI serverUrl, String serverSecret) {
        this.eventPriorities.put(TickEvent.class, 130);
        this.eventPriorities.put(dev.robocode.tankroyale.botapi.events.WonRoundEvent.class, 150);
        this.eventPriorities.put(SkippedTurnEvent.class, 140);
        this.eventPriorities.put(CustomEvent.class, 120);
        this.eventPriorities.put(dev.robocode.tankroyale.botapi.events.BotDeathEvent.class, 100);
        this.eventPriorities.put(dev.robocode.tankroyale.botapi.events.BulletFiredEvent.class, 60);
        this.eventPriorities.put(BulletHitWallEvent.class, 90);
        this.eventPriorities.put(dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent.class, 80);
        this.eventPriorities.put(dev.robocode.tankroyale.botapi.events.BulletHitBotEvent.class, 70);
        this.eventPriorities.put(HitByBulletEvent.class, 50);
        this.eventPriorities.put(HitWallEvent.class, 40);
        this.eventPriorities.put(HitBotEvent.class, 30);
        this.eventPriorities.put(dev.robocode.tankroyale.botapi.events.ScannedBotEvent.class, 20);
        this.eventPriorities.put(DeathEvent.class, 10);
        RuntimeTypeAdapterFactory<WonRoundEvent> typeFactory = RuntimeTypeAdapterFactory.of(Event.class, "type").registerSubtype(BotDeathEvent.class, "BotDeathEvent").registerSubtype(BotHitBotEvent.class, "BotHitBotEvent").registerSubtype(BotHitWallEvent.class, "BotHitWallEvent").registerSubtype(BulletFiredEvent.class, "BulletFiredEvent").registerSubtype(BulletHitBotEvent.class, "BulletHitBotEvent").registerSubtype(BulletHitBulletEvent.class, "BulletHitBulletEvent").registerSubtype(dev.robocode.tankroyale.schema.BulletHitWallEvent.class, "BulletHitWallEvent").registerSubtype(ScannedBotEvent.class, "ScannedBotEvent").registerSubtype(WonRoundEvent.class, "WonRoundEvent");
        this.gson = new GsonBuilder().registerTypeAdapterFactory(typeFactory).serializeSpecialFloatingPointValues().create();
        this.baseBot = baseBot;
        this.botInfo = botInfo == null ? EnvVars.getBotInfo() : botInfo;
        this.botEventHandlers = new BotEventHandlers(baseBot);
        this.eventQueue = new EventQueue(this, this.botEventHandlers);
        this.serverUrl = serverUrl == null ? this.getServerUrlFromSetting() : serverUrl;
        this.serverSecret = serverSecret == null ? this.getServerSecretFromSetting() : serverSecret;
        this.init();
    }

    private void init() {
        this.botEventHandlers.onRoundStarted.subscribe(this::onRoundStarted, 100);
        this.botEventHandlers.onNextTurn.subscribe(this::onNextTurn, 100);
        this.botEventHandlers.onBulletFired.subscribe(this::onBulletFired, 100);
    }

    public void setRunning(boolean isRunning) {
        this.isRunning.set(isRunning);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void enableEventHandling(boolean enable) {
        this.eventHandlingDisabled = !enable;
    }

    public void setStopResumeHandler(IStopResumeListener listener) {
        this.stopResumeListener = listener;
    }

    private static BotIntent newBotIntent() {
        BotIntent botIntent = new BotIntent();
        botIntent.setType(Message.Type.BOT_INTENT);
        return botIntent;
    }

    BotEventHandlers getBotEventHandlers() {
        return this.botEventHandlers;
    }

    public List<BotEvent> getEvents() {
        return this.eventQueue.getEvents();
    }

    public void clearEvents() {
        this.eventQueue.clearEvents();
    }

    public void setInterruptible(boolean interruptible) {
        this.eventQueue.setInterruptible(interruptible);
    }

    void setScannedBotEventInterruptible() {
        this.eventQueue.setInterruptible(dev.robocode.tankroyale.botapi.events.ScannedBotEvent.class, true);
    }

    Set<Condition> getConditions() {
        return this.conditions;
    }

    private void onRoundStarted(RoundStartedEvent e) {
        this.botIntent = BaseBotInternals.newBotIntent();
        this.eventQueue.clear();
        this.isStopped = false;
        this.eventHandlingDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNextTurn(TickEvent e) {
        Object object = this.nextTurnMonitor;
        synchronized (object) {
            this.nextTurnMonitor.notifyAll();
        }
    }

    private void onBulletFired(dev.robocode.tankroyale.botapi.events.BulletFiredEvent e) {
        this.botIntent.setFirepower(0.0);
    }

    public void start() {
        this.connect();
        try {
            this.closedLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void connect() {
        try {
            HttpClient httpClient = HttpClient.newBuilder().build();
            WebSocket.Builder webSocketBuilder = httpClient.newWebSocketBuilder();
            this.socket = webSocketBuilder.buildAsync(this.serverUrl, new WebSocketListener()).join();
        }
        catch (Exception ex) {
            throw new BotException("Could not create web socket for URL: " + this.serverUrl);
        }
    }

    public void execute() {
        if (!this.isRunning()) {
            return;
        }
        int turnNumber = this.getCurrentTick().getTurnNumber();
        this.dispatchEvents(turnNumber);
        this.sendIntent();
        this.waitForNextTurn(turnNumber);
    }

    private void sendIntent() {
        this.limitTargetSpeedAndTurnRates();
        this.socket.sendText(this.gson.toJson(this.botIntent), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextTurn(int turnNumber) {
        Object object = this.nextTurnMonitor;
        synchronized (object) {
            while (this.isRunning() && turnNumber == this.getCurrentTick().getTurnNumber()) {
                try {
                    this.nextTurnMonitor.wait();
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private void dispatchEvents(int turnNumber) {
        try {
            this.eventQueue.dispatchEvents(turnNumber);
        }
        catch (InterruptEventHandlerException interruptEventHandlerException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void limitTargetSpeedAndTurnRates() {
        Double radarTurnRate;
        Double gunTurnRate;
        Double turnRate;
        Double targetSpeed = this.botIntent.getTargetSpeed();
        if (targetSpeed != null) {
            this.botIntent.setTargetSpeed(MathUtil.clamp(targetSpeed, -this.maxSpeed, this.maxSpeed));
        }
        if ((turnRate = this.botIntent.getTurnRate()) != null) {
            this.botIntent.setTurnRate(MathUtil.clamp(turnRate, -this.maxTurnRate, this.maxTurnRate));
        }
        if ((gunTurnRate = this.botIntent.getGunTurnRate()) != null) {
            this.botIntent.setGunTurnRate(MathUtil.clamp(gunTurnRate, -this.maxGunTurnRate, this.maxGunTurnRate));
        }
        if ((radarTurnRate = this.botIntent.getRadarTurnRate()) != null) {
            this.botIntent.setRadarTurnRate(MathUtil.clamp(radarTurnRate, -this.maxRadarTurnRate, this.maxRadarTurnRate));
        }
    }

    public String getVariant() {
        return this.getServerHandshake().getVariant();
    }

    public String getVersion() {
        return this.getServerHandshake().getVersion();
    }

    public int getMyId() {
        if (this.myId == null) {
            throw new BotException(GAME_NOT_RUNNING_MSG);
        }
        return this.myId;
    }

    public GameSetup getGameSetup() {
        if (this.gameSetup == null) {
            throw new BotException(GAME_NOT_RUNNING_MSG);
        }
        return this.gameSetup;
    }

    public BotIntent getBotIntent() {
        if (this.botIntent == null) {
            throw new BotException(GAME_NOT_RUNNING_MSG);
        }
        return this.botIntent;
    }

    public TickEvent getCurrentTick() {
        if (this.tickEvent == null) {
            throw new BotException(TICK_NOT_AVAILABLE_MSG);
        }
        return this.tickEvent;
    }

    private long getTicksStart() {
        if (this.tickStartNanoTime == null) {
            throw new BotException(TICK_NOT_AVAILABLE_MSG);
        }
        return this.tickStartNanoTime;
    }

    public int getTimeLeft() {
        long passesMicroSeconds = (System.nanoTime() - this.getTicksStart()) / 1000L;
        return (int)((long)this.getGameSetup().getTurnTimeout() - passesMicroSeconds);
    }

    public boolean setFire(double firepower) {
        if (Double.isNaN(firepower)) {
            throw new IllegalArgumentException("firepower cannot be NaN");
        }
        if (this.baseBot.getEnergy() < firepower || this.baseBot.getGunHeat() > 0.0) {
            return false;
        }
        this.botIntent.setFirepower(firepower);
        return true;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = MathUtil.clamp(maxSpeed, 0.0, 8.0);
    }

    public double getMaxTurnRate() {
        return this.maxTurnRate;
    }

    public void setMaxTurnRate(double maxTurnRate) {
        this.maxTurnRate = MathUtil.clamp(maxTurnRate, 0.0, 10.0);
    }

    public double getMaxGunTurnRate() {
        return this.maxGunTurnRate;
    }

    public void setMaxGunTurnRate(double maxGunTurnRate) {
        this.maxGunTurnRate = MathUtil.clamp(maxGunTurnRate, 0.0, 20.0);
    }

    public double getMaxRadarTurnRate() {
        return this.maxRadarTurnRate;
    }

    public void setMaxRadarTurnRate(double maxRadarTurnRate) {
        this.maxRadarTurnRate = MathUtil.clamp(maxRadarTurnRate, 0.0, 45.0);
    }

    double getNewTargetSpeed(double speed, double distance) {
        if (distance < 0.0) {
            return -this.getNewTargetSpeed(-speed, -distance);
        }
        double targetSpeed = distance == Double.POSITIVE_INFINITY ? this.maxSpeed : Math.min(this.maxSpeed, this.getMaxSpeed(distance));
        return speed >= 0.0 ? MathUtil.clamp(targetSpeed, speed - this.absDeceleration, speed + 1.0) : MathUtil.clamp(targetSpeed, speed - 1.0, speed + this.getMaxDeceleration(-speed));
    }

    private double getMaxSpeed(double distance) {
        double decelerationTime = Math.max(1.0, Math.ceil((Math.sqrt(8.0 / this.absDeceleration * distance + 1.0) - 1.0) / 2.0));
        if (decelerationTime == Double.POSITIVE_INFINITY) {
            return 8.0;
        }
        double decelerationDistance = decelerationTime / 2.0 * (decelerationTime - 1.0) * this.absDeceleration;
        return (decelerationTime - 1.0) * this.absDeceleration + (distance - decelerationDistance) / decelerationTime;
    }

    private double getMaxDeceleration(double speed) {
        double decelerationTime = speed / this.absDeceleration;
        double accelerationTime = 1.0 - decelerationTime;
        return Math.min(1.0, decelerationTime) * this.absDeceleration + Math.max(0.0, accelerationTime) * 1.0;
    }

    double getDistanceTraveledUntilStop(double speed) {
        speed = Math.abs(speed);
        double distance = 0.0;
        while (speed > 0.0) {
            speed = this.getNewTargetSpeed(speed, 0.0);
            distance += speed;
        }
        return distance;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void removeCondition(Condition condition) {
        this.conditions.remove(condition);
    }

    public void setStop() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this.savedTargetSpeed = this.botIntent.getTargetSpeed();
        this.savedTurnRate = this.botIntent.getTurnRate();
        this.savedGunTurnRate = this.botIntent.getGunTurnRate();
        this.savedRadarTurnRate = this.botIntent.getRadarTurnRate();
        this.botIntent.setTargetSpeed(0.0);
        this.botIntent.setTurnRate(0.0);
        this.botIntent.setGunTurnRate(0.0);
        this.botIntent.setRadarTurnRate(0.0);
        if (this.stopResumeListener != null) {
            this.stopResumeListener.onStop();
        }
    }

    public void setResume() {
        if (!this.isStopped) {
            return;
        }
        this.botIntent.setTargetSpeed(this.savedTargetSpeed);
        this.botIntent.setTurnRate(this.savedTurnRate);
        this.botIntent.setGunTurnRate(this.savedGunTurnRate);
        this.botIntent.setRadarTurnRate(this.savedRadarTurnRate);
        if (this.stopResumeListener != null) {
            this.stopResumeListener.onResume();
        }
        this.isStopped = false;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public int getPriority(Class<BotEvent> eventClass) {
        if (!this.eventPriorities.containsKey(eventClass)) {
            throw new IllegalStateException("Could not get event priority for the class: " + eventClass.getSimpleName());
        }
        return this.eventPriorities.get(eventClass);
    }

    public void setPriority(Class<BotEvent> eventClass, int priority) {
        this.eventPriorities.put(eventClass, priority);
    }

    private ServerHandshake getServerHandshake() {
        if (this.serverHandshake == null) {
            throw new BotException(NOT_CONNECTED_TO_SERVER_MSG);
        }
        return this.serverHandshake;
    }

    private URI getServerUrlFromSetting() {
        String url = System.getProperty(SERVER_URL_PROPERTY_KEY);
        if (url == null) {
            url = EnvVars.getServerUrl();
        }
        if (url == null) {
            url = DEFAULT_SERVER_URL;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new BotException("Incorrect syntax for server URL: " + url + ". Default is: ws://localhost:7654");
        }
    }

    private String getServerSecretFromSetting() {
        String secret = System.getProperty(SERVER_SECRET_PROPERTY_KEY);
        if (secret == null) {
            secret = EnvVars.getServerSecret();
        }
        return secret;
    }

    private final class WebSocketListener
    implements WebSocket.Listener {
        StringBuffer payload = new StringBuffer();

        private WebSocketListener() {
        }

        @Override
        public void onOpen(WebSocket websocket) {
            BaseBotInternals.this.socket = websocket;
            BaseBotInternals.this.botEventHandlers.onConnected.publish(new ConnectedEvent(BaseBotInternals.this.serverUrl));
            WebSocket.Listener.super.onOpen(websocket);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket websocket, int statusCode, String reason) {
            BaseBotInternals.this.botEventHandlers.onDisconnected.publish(new DisconnectedEvent(BaseBotInternals.this.serverUrl, true, statusCode, reason));
            BaseBotInternals.this.closedLatch.countDown();
            return null;
        }

        @Override
        public void onError(WebSocket websocket, Throwable error) {
            BaseBotInternals.this.botEventHandlers.onConnectionError.publish(new ConnectionErrorEvent(BaseBotInternals.this.serverUrl, error));
            BaseBotInternals.this.closedLatch.countDown();
            System.out.println("Exiting");
            System.exit(1);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.payload.append(data);
            if (last) {
                JsonObject jsonMsg = BaseBotInternals.this.gson.fromJson(this.payload.toString(), JsonObject.class);
                this.payload.delete(0, this.payload.length());
                JsonElement jsonType = jsonMsg.get("type");
                if (jsonType != null) {
                    String type = jsonType.getAsString();
                    switch (Message.Type.fromValue(type)) {
                        case TICK_EVENT_FOR_BOT: {
                            this.handleTick(jsonMsg);
                            break;
                        }
                        case ROUND_STARTED_EVENT: {
                            this.handleRoundStarted(jsonMsg);
                            break;
                        }
                        case ROUND_ENDED_EVENT: {
                            this.handleRoundEnded(jsonMsg);
                            break;
                        }
                        case GAME_STARTED_EVENT_FOR_BOT: {
                            this.handleGameStarted(jsonMsg);
                            break;
                        }
                        case GAME_ENDED_EVENT_FOR_BOT: {
                            this.handleGameEnded(jsonMsg);
                            break;
                        }
                        case SKIPPED_TURN_EVENT: {
                            this.handleSkippedTurn(jsonMsg);
                            break;
                        }
                        case SERVER_HANDSHAKE: {
                            this.handleServerHandshake(jsonMsg);
                            break;
                        }
                        case GAME_ABORTED_EVENT: {
                            this.handleGameAborted();
                            break;
                        }
                        default: {
                            throw new BotException("Unsupported WebSocket message type: " + type);
                        }
                    }
                }
            }
            return WebSocket.Listener.super.onText(webSocket, data, last);
        }

        private void handleTick(JsonObject jsonMsg) {
            if (BaseBotInternals.this.eventHandlingDisabled) {
                return;
            }
            BaseBotInternals.this.tickStartNanoTime = System.nanoTime();
            TickEventForBot tickEventForBot = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, TickEventForBot.class);
            BaseBotInternals.this.tickEvent = EventMapper.map(tickEventForBot, (int)BaseBotInternals.this.myId);
            if (BaseBotInternals.this.botIntent.getRescan() != null && BaseBotInternals.this.botIntent.getRescan().booleanValue()) {
                BaseBotInternals.this.botIntent.setRescan(false);
            }
            BaseBotInternals.this.eventQueue.addEventsFromTick(BaseBotInternals.this.tickEvent);
            BaseBotInternals.this.botEventHandlers.onNextTurn.publish(BaseBotInternals.this.tickEvent);
        }

        private void handleRoundStarted(JsonObject jsonMsg) {
            RoundStartedEvent roundStartedEvent = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, RoundStartedEvent.class);
            BaseBotInternals.this.botEventHandlers.onRoundStarted.publish(new RoundStartedEvent(roundStartedEvent.getRoundNumber()));
        }

        private void handleRoundEnded(JsonObject jsonMsg) {
            RoundEndedEvent roundEndedEvent = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, RoundEndedEvent.class);
            BaseBotInternals.this.botEventHandlers.onRoundEnded.publish(new RoundEndedEvent(roundEndedEvent.getRoundNumber(), roundEndedEvent.getTurnNumber()));
        }

        private void handleGameStarted(JsonObject jsonMsg) {
            GameStartedEventForBot gameStartedEventForBot = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, GameStartedEventForBot.class);
            BaseBotInternals.this.myId = gameStartedEventForBot.getMyId();
            BaseBotInternals.this.gameSetup = GameSetupMapper.map(gameStartedEventForBot.getGameSetup());
            BotReady ready = new BotReady();
            ready.setType(Message.Type.BOT_READY);
            String msg = BaseBotInternals.this.gson.toJson(ready);
            BaseBotInternals.this.socket.sendText(msg, true);
            BaseBotInternals.this.botEventHandlers.onGameStarted.publish(new GameStartedEvent(gameStartedEventForBot.getMyId(), BaseBotInternals.this.gameSetup));
        }

        private void handleGameEnded(JsonObject jsonMsg) {
            GameEndedEventForBot gameEndedEventForBot = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, GameEndedEventForBot.class);
            GameEndedEvent gameEndedEvent = new GameEndedEvent(gameEndedEventForBot.getNumberOfRounds(), ResultsMapper.map(gameEndedEventForBot.getResults()));
            BaseBotInternals.this.botEventHandlers.onGameEnded.publish(gameEndedEvent);
        }

        private void handleGameAborted() {
            BaseBotInternals.this.botEventHandlers.onGameAborted.publish(null);
        }

        private void handleSkippedTurn(JsonObject jsonMsg) {
            if (BaseBotInternals.this.eventHandlingDisabled) {
                return;
            }
            dev.robocode.tankroyale.schema.SkippedTurnEvent skippedTurnEvent = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, dev.robocode.tankroyale.schema.SkippedTurnEvent.class);
            BaseBotInternals.this.botEventHandlers.onSkippedTurn.publish((SkippedTurnEvent)EventMapper.map(skippedTurnEvent, (int)BaseBotInternals.this.myId));
        }

        private void handleServerHandshake(JsonObject jsonMsg) {
            BaseBotInternals.this.serverHandshake = BaseBotInternals.this.gson.fromJson((JsonElement)jsonMsg, ServerHandshake.class);
            BotHandshake botHandshake = BotHandshakeFactory.create(BaseBotInternals.this.botInfo, BaseBotInternals.this.serverSecret);
            String msg = BaseBotInternals.this.gson.toJson(botHandshake);
            BaseBotInternals.this.socket.sendText(msg, true);
        }
    }
}

