/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.events.BotDeathEvent;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletFiredEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.ConnectedEvent;
import dev.robocode.tankroyale.botapi.events.ConnectionErrorEvent;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.GameStartedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.RoundEndedEvent;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.events.WonRoundEvent;
import dev.robocode.tankroyale.botapi.internal.EventHandler;

final class BotEventHandlers {
    final IBaseBot baseBot;
    final EventHandler<ConnectedEvent> onConnected = new EventHandler();
    final EventHandler<DisconnectedEvent> onDisconnected = new EventHandler();
    final EventHandler<ConnectionErrorEvent> onConnectionError = new EventHandler();
    final EventHandler<GameStartedEvent> onGameStarted = new EventHandler();
    final EventHandler<GameEndedEvent> onGameEnded = new EventHandler();
    final EventHandler<Void> onGameAborted = new EventHandler();
    final EventHandler<RoundStartedEvent> onRoundStarted = new EventHandler();
    final EventHandler<RoundEndedEvent> onRoundEnded = new EventHandler();
    final EventHandler<TickEvent> onTick = new EventHandler();
    final EventHandler<SkippedTurnEvent> onSkippedTurn = new EventHandler();
    final EventHandler<DeathEvent> onDeath = new EventHandler();
    final EventHandler<BotDeathEvent> onBotDeath = new EventHandler();
    final EventHandler<HitBotEvent> onHitBot = new EventHandler();
    final EventHandler<HitWallEvent> onHitWall = new EventHandler();
    final EventHandler<BulletFiredEvent> onBulletFired = new EventHandler();
    final EventHandler<HitByBulletEvent> onHitByBullet = new EventHandler();
    final EventHandler<BulletHitBotEvent> onBulletHit = new EventHandler();
    final EventHandler<BulletHitBulletEvent> onBulletHitBullet = new EventHandler();
    final EventHandler<BulletHitWallEvent> onBulletHitWall = new EventHandler();
    final EventHandler<ScannedBotEvent> onScannedBot = new EventHandler();
    final EventHandler<WonRoundEvent> onWonRound = new EventHandler();
    final EventHandler<CustomEvent> onCustomEvent = new EventHandler();
    final EventHandler<TickEvent> onNextTurn = new EventHandler();

    BotEventHandlers(IBaseBot baseBot) {
        this.baseBot = baseBot;
        this.onConnected.subscribe(baseBot::onConnected);
        this.onDisconnected.subscribe(baseBot::onDisconnected);
        this.onConnectionError.subscribe(baseBot::onConnectionError);
        this.onGameStarted.subscribe(baseBot::onGameStarted);
        this.onGameEnded.subscribe(baseBot::onGameEnded);
        this.onRoundStarted.subscribe(baseBot::onRoundStarted);
        this.onRoundEnded.subscribe(baseBot::onRoundEnded);
        this.onTick.subscribe(baseBot::onTick);
        this.onSkippedTurn.subscribe(baseBot::onSkippedTurn);
        this.onDeath.subscribe(baseBot::onDeath);
        this.onBotDeath.subscribe(baseBot::onBotDeath);
        this.onHitBot.subscribe(baseBot::onHitBot);
        this.onHitWall.subscribe(baseBot::onHitWall);
        this.onBulletFired.subscribe(baseBot::onBulletFired);
        this.onHitByBullet.subscribe(baseBot::onHitByBullet);
        this.onBulletHit.subscribe(baseBot::onBulletHit);
        this.onBulletHitBullet.subscribe(baseBot::onBulletHitBullet);
        this.onBulletHitWall.subscribe(baseBot::onBulletHitWall);
        this.onScannedBot.subscribe(baseBot::onScannedBot);
        this.onWonRound.subscribe(baseBot::onWonRound);
        this.onCustomEvent.subscribe(baseBot::onCustomEvent);
    }

    void fire(BotEvent event) {
        if (event instanceof TickEvent) {
            this.onTick.publish((TickEvent)event);
        } else if (event instanceof ScannedBotEvent) {
            this.onScannedBot.publish((ScannedBotEvent)event);
        } else if (event instanceof SkippedTurnEvent) {
            this.onSkippedTurn.publish((SkippedTurnEvent)event);
        } else if (event instanceof HitBotEvent) {
            this.onHitBot.publish((HitBotEvent)event);
        } else if (event instanceof HitWallEvent) {
            this.onHitWall.publish((HitWallEvent)event);
        } else if (event instanceof BulletFiredEvent) {
            this.onBulletFired.publish((BulletFiredEvent)event);
        } else if (event instanceof BulletHitWallEvent) {
            this.onBulletHitWall.publish((BulletHitWallEvent)event);
        } else if (event instanceof HitByBulletEvent) {
            this.onHitByBullet.publish((HitByBulletEvent)event);
        } else if (event instanceof BulletHitBotEvent) {
            this.onBulletHit.publish((BulletHitBotEvent)event);
        } else if (event instanceof BotDeathEvent) {
            this.onBotDeath.publish((BotDeathEvent)event);
        } else if (event instanceof DeathEvent) {
            this.onDeath.publish((DeathEvent)event);
        } else if (event instanceof BulletHitBulletEvent) {
            this.onBulletHitBullet.publish((BulletHitBulletEvent)event);
        } else if (event instanceof WonRoundEvent) {
            this.onWonRound.publish((WonRoundEvent)event);
        } else if (event instanceof CustomEvent) {
            this.onCustomEvent.publish((CustomEvent)event);
        } else {
            throw new IllegalStateException("Unhandled event type: " + event);
        }
    }
}

