/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.Bot;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.IStopResumeListener;

public final class BotInternals
implements IStopResumeListener {
    private final Bot bot;
    private final BaseBotInternals baseBotInternals;
    private Thread thread;
    private double previousDirection;
    private double previousGunDirection;
    private double previousRadarDirection;
    private double __distanceRemaining;
    private double __turnRemaining;
    private double __gunTurnRemaining;
    private double __radarTurnRemaining;
    private boolean isOverDriving;
    private double savedPreviousDirection;
    private double savedPreviousGunDirection;
    private double savedPreviousRadarDirection;
    private double savedDistanceRemaining;
    private double savedTurnRemaining;
    private double savedGunTurnRemaining;
    private double savedRadarTurnRemaining;
    private final Object movementMonitor = new Object();
    private final Object turnMonitor = new Object();
    private final Object gunTurnMonitor = new Object();
    private final Object radarTurnMonitor = new Object();

    public BotInternals(Bot bot, BaseBotInternals baseBotInternals) {
        this.bot = bot;
        this.baseBotInternals = baseBotInternals;
        baseBotInternals.setStopResumeHandler(this);
        BotEventHandlers botEventHandlers = baseBotInternals.getBotEventHandlers();
        botEventHandlers.onGameAborted.subscribe(e -> this.onGameAborted(), 100);
        botEventHandlers.onNextTurn.subscribe(this::onNextTurn, 90);
        botEventHandlers.onRoundEnded.subscribe(e -> this.onRoundEnded(), 90);
        botEventHandlers.onGameEnded.subscribe(this::onGameEnded, 90);
        botEventHandlers.onDisconnected.subscribe(this::onDisconnected, 90);
        botEventHandlers.onHitWall.subscribe(e -> this.onHitWall(), 90);
        botEventHandlers.onHitBot.subscribe(this::onHitBot, 90);
        botEventHandlers.onDeath.subscribe(this::onDeath, 90);
    }

    private void onNextTurn(TickEvent e) {
        if (e.getTurnNumber() == 1) {
            this.onFirstTurn();
        }
        this.processTurn();
    }

    private void onFirstTurn() {
        this.stopThread();
        this.clearRemaining();
        this.startThread();
    }

    private void clearRemaining() {
        this.setDistanceRemaining(0.0);
        this.setTurnRemaining(0.0);
        this.setGunTurnRemaining(0.0);
        this.setRadarTurnRemaining(0.0);
        this.previousDirection = this.bot.getDirection();
        this.previousGunDirection = this.bot.getGunDirection();
        this.previousRadarDirection = this.bot.getRadarDirection();
    }

    private void onGameAborted() {
        this.stopThread();
    }

    private void onRoundEnded() {
        this.stopThread();
    }

    private void onGameEnded(GameEndedEvent e) {
        this.stopThread();
    }

    private void onDisconnected(DisconnectedEvent e) {
        this.stopThread();
    }

    private void processTurn() {
        if (this.bot.isDisabled()) {
            this.clearRemaining();
        } else {
            this.updateTurnRemaining();
            this.updateGunTurnRemaining();
            this.updateRadarTurnRemaining();
            this.updateMovement();
        }
    }

    private void startThread() {
        this.thread = new Thread(() -> {
            this.baseBotInternals.setRunning(true);
            try {
                this.baseBotInternals.enableEventHandling(true);
                this.bot.run();
                while (this.baseBotInternals.isRunning()) {
                    this.bot.go();
                }
            }
            finally {
                this.baseBotInternals.enableEventHandling(false);
            }
        });
        this.thread.start();
    }

    private void stopThread() {
        if (!this.isRunning()) {
            return;
        }
        this.baseBotInternals.setRunning(false);
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
                if (this.thread.isAlive()) {
                    this.thread.stop();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.thread = null;
            }
        }
    }

    private void onHitWall() {
        this.setDistanceRemaining(0.0);
    }

    private void onHitBot(HitBotEvent e) {
        if (e.isRammed()) {
            this.setDistanceRemaining(0.0);
        }
    }

    private void onDeath(DeathEvent e) {
        this.stopThread();
    }

    public boolean isRunning() {
        return this.baseBotInternals.isRunning();
    }

    public void setTurnRate(double turnRate) {
        if (Double.isNaN(turnRate)) {
            throw new IllegalArgumentException("turnRate cannot be NaN");
        }
        this.baseBotInternals.getBotIntent().setTurnRate(turnRate);
        this.setTurnRemaining(BotInternals.toInfiniteValue(turnRate));
    }

    public void setGunTurnRate(double gunTurnRate) {
        if (Double.isNaN(gunTurnRate)) {
            throw new IllegalArgumentException("gunTurnRate cannot be NaN");
        }
        this.baseBotInternals.getBotIntent().setGunTurnRate(gunTurnRate);
        this.setGunTurnRemaining(BotInternals.toInfiniteValue(gunTurnRate));
    }

    public void setRadarTurnRate(double radarTurnRate) {
        if (Double.isNaN(radarTurnRate)) {
            throw new IllegalArgumentException("radarTurnRate cannot be NaN");
        }
        this.baseBotInternals.getBotIntent().setRadarTurnRate(radarTurnRate);
        this.setRadarTurnRemaining(BotInternals.toInfiniteValue(radarTurnRate));
    }

    private static double toInfiniteValue(double turnRate) {
        if (turnRate > 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (turnRate < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDistanceRemaining(double newDistanceRemaining) {
        Object object = this.movementMonitor;
        synchronized (object) {
            this.__distanceRemaining = newDistanceRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDistanceRemaining() {
        Object object = this.movementMonitor;
        synchronized (object) {
            return this.__distanceRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTurnRemaining(double newTurnRemaining) {
        Object object = this.turnMonitor;
        synchronized (object) {
            this.__turnRemaining = newTurnRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTurnRemaining() {
        Object object = this.turnMonitor;
        synchronized (object) {
            return this.__turnRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGunTurnRemaining(double newGunTurnRemaining) {
        Object object = this.gunTurnMonitor;
        synchronized (object) {
            this.__gunTurnRemaining = newGunTurnRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getGunTurnRemaining() {
        Object object = this.gunTurnMonitor;
        synchronized (object) {
            return this.__gunTurnRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRadarTurnRemaining(double newRadarTurnRemaining) {
        Object object = this.radarTurnMonitor;
        synchronized (object) {
            this.__radarTurnRemaining = newRadarTurnRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRadarTurnRemaining() {
        Object object = this.radarTurnMonitor;
        synchronized (object) {
            return this.__radarTurnRemaining;
        }
    }

    public void setTargetSpeed(double targetSpeed) {
        if (Double.isNaN(targetSpeed)) {
            throw new IllegalArgumentException("targetSpeed cannot be NaN");
        }
        double distanceRemaining = targetSpeed > 0.0 ? Double.POSITIVE_INFINITY : (targetSpeed < 0.0 ? Double.NEGATIVE_INFINITY : 0.0);
        this.setDistanceRemaining(distanceRemaining);
        this.baseBotInternals.getBotIntent().setTargetSpeed(targetSpeed);
    }

    public void setForward(double distance) {
        if (Double.isNaN(distance)) {
            throw new IllegalArgumentException("distance cannot be NaN");
        }
        double speed = this.baseBotInternals.getNewTargetSpeed(this.bot.getSpeed(), distance);
        this.baseBotInternals.getBotIntent().setTargetSpeed(speed);
        this.setDistanceRemaining(distance);
    }

    public void forward(double distance) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setForward(distance);
            do {
                this.bot.go();
            } while (this.isRunning() && (this.getDistanceRemaining() != 0.0 || this.bot.getSpeed() != 0.0));
        }
    }

    public void setTurnLeft(double degrees) {
        if (Double.isNaN(degrees)) {
            throw new IllegalArgumentException("degrees cannot be NaN");
        }
        this.setTurnRemaining(degrees);
        this.baseBotInternals.getBotIntent().setTurnRate(degrees);
    }

    public void turnLeft(double degrees) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setTurnLeft(degrees);
            do {
                this.bot.go();
            } while (this.isRunning() && (this.getTurnRemaining() != 0.0 || this.bot.getTurnRate() != 0.0));
        }
    }

    public void setTurnGunLeft(double degrees) {
        if (Double.isNaN(degrees)) {
            throw new IllegalArgumentException("degrees cannot be NaN");
        }
        this.setGunTurnRemaining(degrees);
        this.baseBotInternals.getBotIntent().setGunTurnRate(degrees);
    }

    public void turnGunLeft(double degrees) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setTurnGunLeft(degrees);
            do {
                this.bot.go();
            } while (this.isRunning() && (this.getGunTurnRemaining() != 0.0 || this.bot.getGunTurnRate() != 0.0));
        }
    }

    public void setTurnRadarLeft(double degrees) {
        if (Double.isNaN(degrees)) {
            throw new IllegalArgumentException("degrees cannot be NaN");
        }
        this.setRadarTurnRemaining(degrees);
        this.baseBotInternals.getBotIntent().setRadarTurnRate(degrees);
    }

    public void turnRadarLeft(double degrees) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setTurnRadarLeft(degrees);
            do {
                this.bot.go();
            } while (this.isRunning() && (this.getRadarTurnRemaining() != 0.0 || this.bot.getRadarTurnRate() != 0.0));
        }
    }

    public void fire(double firepower) {
        if (this.bot.setFire(firepower)) {
            this.bot.go();
        }
    }

    public void rescan() {
        this.baseBotInternals.setScannedBotEventInterruptible();
        this.bot.setRescan();
        this.bot.go();
    }

    public void waitFor(Condition condition) {
        while (this.isRunning() && !condition.test()) {
            this.bot.setRescan();
            this.bot.go();
        }
    }

    public void stop() {
        this.baseBotInternals.setStop();
        this.bot.go();
    }

    public void resume() {
        this.baseBotInternals.setResume();
        this.bot.go();
    }

    @Override
    public void onStop() {
        this.savedPreviousDirection = this.previousDirection;
        this.savedPreviousGunDirection = this.previousGunDirection;
        this.savedPreviousRadarDirection = this.previousRadarDirection;
        this.savedDistanceRemaining = this.getDistanceRemaining();
        this.savedTurnRemaining = this.getTurnRemaining();
        this.savedGunTurnRemaining = this.getGunTurnRemaining();
        this.savedRadarTurnRemaining = this.getRadarTurnRemaining();
    }

    @Override
    public void onResume() {
        this.previousDirection = this.savedPreviousDirection;
        this.previousGunDirection = this.savedPreviousGunDirection;
        this.previousRadarDirection = this.savedPreviousRadarDirection;
        this.setDistanceRemaining(this.savedDistanceRemaining);
        this.setTurnRemaining(this.savedTurnRemaining);
        this.setGunTurnRemaining(this.savedGunTurnRemaining);
        this.setRadarTurnRemaining(this.savedRadarTurnRemaining);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTurnRemaining() {
        Object object = this.turnMonitor;
        synchronized (object) {
            double delta = this.bot.calcDeltaAngle(this.bot.getDirection(), this.previousDirection);
            this.previousDirection = this.bot.getDirection();
            if (Math.abs(this.__turnRemaining) <= Math.abs(delta)) {
                this.__turnRemaining = 0.0;
            } else {
                this.__turnRemaining -= delta;
                if (this.isNearZero(this.__turnRemaining)) {
                    this.__turnRemaining = 0.0;
                }
            }
            this.baseBotInternals.getBotIntent().setTurnRate(this.__turnRemaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGunTurnRemaining() {
        Object object = this.gunTurnMonitor;
        synchronized (object) {
            double delta = this.bot.calcDeltaAngle(this.bot.getGunDirection(), this.previousGunDirection);
            this.previousGunDirection = this.bot.getGunDirection();
            if (Math.abs(this.__gunTurnRemaining) <= Math.abs(delta)) {
                this.__gunTurnRemaining = 0.0;
            } else {
                this.__gunTurnRemaining -= delta;
                if (this.isNearZero(this.__gunTurnRemaining)) {
                    this.__gunTurnRemaining = 0.0;
                }
            }
            this.baseBotInternals.getBotIntent().setGunTurnRate(this.__gunTurnRemaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRadarTurnRemaining() {
        Object object = this.radarTurnMonitor;
        synchronized (object) {
            double delta = this.bot.calcDeltaAngle(this.bot.getRadarDirection(), this.previousRadarDirection);
            this.previousRadarDirection = this.bot.getRadarDirection();
            if (Math.abs(this.__radarTurnRemaining) <= Math.abs(delta)) {
                this.__radarTurnRemaining = 0.0;
            } else {
                this.__radarTurnRemaining -= delta;
                if (this.isNearZero(this.__radarTurnRemaining)) {
                    this.__radarTurnRemaining = 0.0;
                }
            }
            this.baseBotInternals.getBotIntent().setRadarTurnRate(this.__radarTurnRemaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMovement() {
        Object object = this.movementMonitor;
        synchronized (object) {
            if (Double.isInfinite(this.__distanceRemaining)) {
                this.baseBotInternals.getBotIntent().setTargetSpeed(Double.valueOf(this.__distanceRemaining == Double.POSITIVE_INFINITY ? 8 : -8));
            } else {
                double distance = this.__distanceRemaining;
                double newSpeed = this.baseBotInternals.getNewTargetSpeed(this.bot.getSpeed(), distance);
                this.baseBotInternals.getBotIntent().setTargetSpeed(newSpeed);
                if (this.isNearZero(newSpeed) && this.isOverDriving) {
                    distance = 0.0;
                    this.isOverDriving = false;
                }
                if (Math.signum(distance * newSpeed) != -1.0) {
                    this.isOverDriving = this.baseBotInternals.getDistanceTraveledUntilStop(newSpeed) > Math.abs(distance);
                }
                this.__distanceRemaining = distance - newSpeed;
            }
        }
    }

    private boolean isNearZero(double value) {
        return Math.abs(value) < 1.0E-5;
    }
}

