/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.BotInfo;
import dev.robocode.tankroyale.botapi.InitialPosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class EnvVars {
    static final String SERVER_URL = "SERVER_URL";
    static final String SERVER_SECRET = "SERVER_SECRET";
    static final String BOT_NAME = "BOT_NAME";
    static final String BOT_VERSION = "BOT_VERSION";
    static final String BOT_AUTHORS = "BOT_AUTHORS";
    static final String BOT_DESCRIPTION = "BOT_DESCRIPTION";
    static final String BOT_HOMEPAGE = "BOT_HOMEPAGE";
    static final String BOT_COUNTRY_CODES = "BOT_COUNTRY_CODES";
    static final String BOT_GAME_TYPES = "BOT_GAME_TYPES";
    static final String BOT_PLATFORM = "BOT_PLATFORM";
    static final String BOT_PROG_LANG = "BOT_PROG_LANG";
    static final String BOT_INITIAL_POS = "BOT_INITIAL_POS";
    private static final String MISSING_ENV_VALUE = "Missing environment variable: ";

    private EnvVars() {
    }

    static BotInfo getBotInfo() {
        if (EnvVars.isBlank(EnvVars.getBotName())) {
            throw new BotException("Missing environment variable: BOT_NAME");
        }
        if (EnvVars.isBlank(EnvVars.getBotVersion())) {
            throw new BotException("Missing environment variable: BOT_VERSION");
        }
        if (EnvVars.isBlank(EnvVars.getBotAuthors())) {
            throw new BotException("Missing environment variable: BOT_AUTHORS");
        }
        if (EnvVars.isBlank(EnvVars.getBotGameTypes())) {
            throw new BotException("Missing environment variable: BOT_GAME_TYPES");
        }
        return new BotInfo(EnvVars.getBotName(), EnvVars.getBotVersion(), EnvVars.getBotAuthors(), EnvVars.getBotDescription(), EnvVars.getBotHomepage(), EnvVars.getBotCountryCodes(), EnvVars.getBotGameTypes(), EnvVars.getBotPlatform(), EnvVars.getBotProgrammingLang(), EnvVars.getBotInitialPosition());
    }

    static String getServerUrl() {
        return System.getenv(SERVER_URL);
    }

    static String getServerSecret() {
        return System.getenv(SERVER_SECRET);
    }

    static String getBotName() {
        return System.getenv(BOT_NAME);
    }

    static String getBotVersion() {
        return System.getenv(BOT_VERSION);
    }

    static List<String> getBotAuthors() {
        return EnvVars.propertyAsList(BOT_AUTHORS);
    }

    static String getBotDescription() {
        return System.getenv(BOT_DESCRIPTION);
    }

    static String getBotHomepage() {
        return System.getenv(BOT_HOMEPAGE);
    }

    static List<String> getBotCountryCodes() {
        return EnvVars.propertyAsList(BOT_COUNTRY_CODES);
    }

    static Set<String> getBotGameTypes() {
        return new HashSet<String>(EnvVars.propertyAsList(BOT_GAME_TYPES));
    }

    static String getBotPlatform() {
        return System.getenv(BOT_PLATFORM);
    }

    static String getBotProgrammingLang() {
        return System.getenv(BOT_PROG_LANG);
    }

    static InitialPosition getBotInitialPosition() {
        return InitialPosition.fromString(System.getenv(BOT_INITIAL_POS));
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static boolean isBlank(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    private static List<String> propertyAsList(String propertyName) {
        String value = System.getenv(propertyName);
        if (value == null || value.trim().length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split("\\s*,\\s*"));
    }
}

