/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

final class EventHandler<T> {
    private final List<EntryWithPriority> subscriberEntries = Collections.synchronizedList(new ArrayList());

    EventHandler() {
    }

    void subscribe(Consumer<T> subscriber, int priority) {
        this.subscriberEntries.add(new EntryWithPriority(subscriber, priority));
    }

    void subscribe(Consumer<T> subscriber) {
        this.subscribe(subscriber, 1);
    }

    void publish(T event) {
        this.subscriberEntries.sort(new EntryWithPriorityComparator());
        for (EntryWithPriority entry : new ArrayList<EntryWithPriority>(this.subscriberEntries)) {
            entry.subscriber.accept(event);
        }
    }

    class EntryWithPriority {
        private final int priority;
        private final Consumer<T> subscriber;

        EntryWithPriority(Consumer<T> subscriber, int priority) {
            this.subscriber = subscriber;
            this.priority = priority;
        }
    }

    class EntryWithPriorityComparator
    implements Comparator<EntryWithPriority> {
        EntryWithPriorityComparator() {
        }

        @Override
        public int compare(EntryWithPriority e1, EntryWithPriority e2) {
            return e2.priority - e1.priority;
        }
    }
}

