/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.InterruptEventHandlerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

final class EventQueue {
    private static final int MAX_QUEUE_SIZE = 256;
    private static final int MAX_EVENT_AGE = 2;
    private final BaseBotInternals baseBotInternals;
    private final BotEventHandlers botEventHandlers;
    private final List<BotEvent> events = new CopyOnWriteArrayList<BotEvent>();
    private BotEvent currentTopEvent;
    private int currentTopEventPriority;
    private final Set<Class<? extends BotEvent>> interruptibles = new HashSet<Class<? extends BotEvent>>();

    public EventQueue(BaseBotInternals baseBotInternals, BotEventHandlers botEventHandlers) {
        this.baseBotInternals = baseBotInternals;
        this.botEventHandlers = botEventHandlers;
    }

    void clear() {
        this.events.clear();
        this.baseBotInternals.getConditions().clear();
        this.currentTopEvent = null;
        this.currentTopEventPriority = Integer.MIN_VALUE;
    }

    List<BotEvent> getEvents() {
        return new ArrayList<BotEvent>(this.events);
    }

    void clearEvents() {
        this.events.clear();
    }

    void setInterruptible(boolean interruptible) {
        this.setInterruptible(this.currentTopEvent.getClass(), interruptible);
    }

    void setInterruptible(Class<? extends BotEvent> eventClass, boolean interruptible) {
        if (interruptible) {
            this.interruptibles.add(eventClass);
        } else {
            this.interruptibles.remove(eventClass);
        }
    }

    private boolean isInterruptible() {
        return this.interruptibles.contains(this.currentTopEvent.getClass());
    }

    void addEventsFromTick(TickEvent event) {
        this.addEvent(event);
        event.getEvents().forEach(this::addEvent);
        this.addCustomEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchEvents(int currentTurn) {
        this.removeOldEvents(currentTurn);
        this.sortEvents();
        while (this.baseBotInternals.isRunning() && this.events.size() > 0) {
            BotEvent event = this.events.get(0);
            int eventPriority = this.getPriority(event);
            if (eventPriority < this.currentTopEventPriority) {
                return;
            }
            if (eventPriority == this.currentTopEventPriority) {
                if (!this.isInterruptible()) {
                    return;
                }
                this.setInterruptible(event.getClass(), false);
                throw new InterruptEventHandlerException();
            }
            int oldTopEventPriority = this.currentTopEventPriority;
            this.currentTopEventPriority = eventPriority;
            this.currentTopEvent = event;
            this.events.remove(event);
            try {
                if (EventQueue.isNotOldOrCriticalEvent(event, currentTurn)) {
                    this.botEventHandlers.fire(event);
                }
                this.setInterruptible(event.getClass(), false);
            }
            catch (InterruptEventHandlerException interruptEventHandlerException) {}
            continue;
            finally {
                this.currentTopEventPriority = oldTopEventPriority;
            }
        }
    }

    private void removeOldEvents(int currentTurn) {
        this.events.removeIf(event -> EventQueue.isOldAndNonCriticalEvent(event, currentTurn));
    }

    private void sortEvents() {
        this.events.sort((e1, e2) -> {
            int timeDiff = e1.getTurnNumber() - e2.getTurnNumber();
            if (timeDiff != 0) {
                return timeDiff;
            }
            return this.getPriority((BotEvent)e2) - this.getPriority((BotEvent)e1);
        });
    }

    private int getPriority(BotEvent event) {
        int priority = this.baseBotInternals.getPriority(event.getClass());
        return priority;
    }

    private static boolean isNotOldOrCriticalEvent(BotEvent event, int currentTurn) {
        boolean isNotOld = event.getTurnNumber() + 2 >= currentTurn;
        boolean isCritical = event.isCritical();
        return isNotOld || isCritical;
    }

    private static boolean isOldAndNonCriticalEvent(BotEvent event, int currentTurn) {
        boolean isOld = event.getTurnNumber() + 2 < currentTurn;
        boolean isNonCritical = !event.isCritical();
        return isOld && isNonCritical;
    }

    private void addEvent(BotEvent event) {
        if (this.events.size() > 256) {
            System.err.println("Maximum event queue size has been reached: 256");
        } else {
            this.events.add(event);
        }
    }

    private void addCustomEvents() {
        this.baseBotInternals.getConditions().stream().filter(Condition::test).forEach(condition -> this.addEvent(new CustomEvent(this.baseBotInternals.getCurrentTick().getTurnNumber(), (Condition)condition)));
    }
}

